/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActionContributionHandler
extends ContributionFragmentRegistry<Action> {
    private final Log log = LogFactory.getLog(ActionContributionHandler.class);
    protected ActionRegistry actionReg = new ActionRegistry();
    protected ActionFilterRegistry filterReg;

    public ActionContributionHandler(ActionFilterRegistry fitlerReg) {
        this.filterReg = fitlerReg;
    }

    public ActionRegistry getRegistry() {
        return this.actionReg;
    }

    public Action clone(Action object) {
        try {
            return object.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void contributionRemoved(String id, Action origContrib) {
        this.actionReg.removeAction(id);
    }

    public void contributionUpdated(String actionId, Action action, Action origAction) {
        List<String> actionFilterIds;
        Action registeredAction = this.actionReg.getAction(actionId);
        if (registeredAction != null) {
            this.log.debug((Object)("Upgrading web action with id " + actionId));
            this.actionReg.removeAction(actionId);
        }
        ArrayList<String> newFilterIds = new ArrayList<String>();
        ActionFilter[] newFilters = action.getFilters();
        if (newFilters != null) {
            for (ActionFilter filter : newFilters) {
                String filterId = filter.getId();
                this.filterReg.removeFilter(filterId);
                this.filterReg.addFilter(filter);
                newFilterIds.add(filterId);
            }
            action.setFilters(null);
        }
        if ((actionFilterIds = action.getFilterIds()) == null) {
            action.setFilterIds(newFilterIds);
        } else {
            actionFilterIds.addAll(newFilterIds);
            action.setFilterIds(actionFilterIds);
        }
        if (action.getLabel() == null) {
            action.setLabel(action.getId());
        }
        this.actionReg.addAction(action);
    }

    public String getContributionId(Action contrib) {
        return contrib.getId();
    }

    public void merge(Action source, Action dest) {
        int newOrder;
        String tooltip;
        String newConfirm;
        String newLink;
        String newIcon = source.getIcon();
        if (newIcon != null && !newIcon.equals(dest.getIcon())) {
            dest.setIcon(newIcon);
        }
        if (source.isEnabled() != dest.isEnabled()) {
            dest.setEnabled(source.isEnabled());
        }
        HashSet<String> mergedCategories = new HashSet<String>(Arrays.asList(dest.getCategories()));
        mergedCategories.addAll(new HashSet<String>(Arrays.asList(source.getCategories())));
        dest.setCategories(mergedCategories.toArray(new String[mergedCategories.size()]));
        String newLabel = source.getLabel();
        if (newLabel != null && !newLabel.equals(dest.getLabel())) {
            dest.setLabel(newLabel);
        }
        if ((newLink = source.getLink()) != null && !newLink.equals(dest.getLink())) {
            dest.setLink(newLink);
        }
        if ((newConfirm = source.getConfirm()) != null && !"".equals(newConfirm) && !newConfirm.equals(dest.getConfirm())) {
            dest.setConfirm(newConfirm);
        }
        if ((tooltip = source.getHelp()) != null && !tooltip.equals(dest.getHelp())) {
            dest.setHelp(tooltip);
        }
        if ((newOrder = source.getOrder()) > 0 && newOrder != dest.getOrder()) {
            dest.setOrder(newOrder);
        }
        ArrayList<String> newFilterIds = new ArrayList<String>();
        newFilterIds.addAll(dest.getFilterIds());
        newFilterIds.addAll(source.getFilterIds());
        dest.setFilterIds(newFilterIds);
        ActionFilter[] existingFilters = dest.getFilters();
        ActionFilter[] newFilters = source.getFilters();
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>();
        if (existingFilters != null) {
            filters.addAll(Arrays.asList(existingFilters));
        }
        if (newFilters != null) {
            filters.addAll(Arrays.asList(newFilters));
        }
        dest.setFilters(filters.toArray(new ActionFilter[0]));
    }
}

