/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions.elcache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.platform.actions.elcache.ThreadSafeJexlExpression;
import org.nuxeo.runtime.expression.JexlExpression;

public class CachedJEXLManager {
    public static boolean enforceThreadSafe = false;
    public static boolean useCache = true;
    private static final Map<String, JexlExpression> expCache = new ConcurrentHashMap<String, JexlExpression>();

    public static JexlExpression getExpression(String elString) throws Exception {
        if (!useCache) {
            return new JexlExpression(elString);
        }
        JexlExpression exp = expCache.get(elString);
        if (exp == null) {
            exp = enforceThreadSafe ? new ThreadSafeJexlExpression(elString) : new JexlExpression(elString);
            expCache.put(elString, exp);
        }
        return exp;
    }
}

