/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;

public class ExceptionHandler {
    protected int status = 500;
    protected String type;
    protected Throwable cause;
    protected String message;

    public static WebApplicationException newException(Throwable cause) {
        return ExceptionHandler.newException(null, cause);
    }

    public static WebApplicationException newException(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        ExceptionHandler e = new ExceptionHandler(message, cause);
        return new WebApplicationException(cause, Response.status((int)e.getStatus()).entity((Object)e).build());
    }

    public static void abort(String message, Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(message, cause);
    }

    public static void abort(Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(null, cause);
    }

    public static int getStatus(Throwable cause) {
        return ExceptionHandler.getStatus(cause, 8);
    }

    public static int getStatus(Throwable cause, int depth) {
        Throwable ccause;
        if (depth == 0) {
            return 500;
        }
        if (cause instanceof DocumentSecurityException || "javax.ejb.EJBAccessException".equals(cause.getClass().getName())) {
            return 401;
        }
        if (cause instanceof ClientException ? (ccause = cause.getCause()) != null && ccause.getMessage() != null && ccause.getMessage().contains("org.nuxeo.ecm.core.model.NoSuchDocumentException") : cause instanceof OperationNotFoundException) {
            return 404;
        }
        Throwable parent = cause.getCause();
        if (parent != null) {
            return ExceptionHandler.getStatus(parent, depth - 1);
        }
        return 500;
    }

    public ExceptionHandler(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        this.status = ExceptionHandler.getStatus(cause);
        this.cause = cause;
        this.message = message == null ? cause.getMessage() : message;
        this.type = cause.getClass().getName();
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.cause.getClass().getName();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSerializedStackTrace() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        this.cause.printStackTrace(pw);
        pw.flush();
        return writer.toString();
    }
}

