/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import net.sf.json.JSONObject;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.io.InputResolver;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshaller;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshalling;
import org.nuxeo.ecm.automation.server.jaxrs.io.resolvers.DocumentInputResolver;
import org.nuxeo.ecm.automation.server.jaxrs.io.resolvers.DocumentsInputResolver;
import org.nuxeo.runtime.api.Framework;

@Provider
@Consumes(value={"application/json+nxrequest"})
public class JsonRequestReader
implements MessageBodyReader<ExecutionRequest> {
    public static final MediaType targetMediaType = new MediaType("application", "json+nxrequest");
    protected static final HashMap<String, InputResolver<?>> inputResolvers = new HashMap();

    protected static JsonMarshalling marshalling() {
        return (JsonMarshalling)Framework.getLocalService(JsonMarshalling.class);
    }

    public static void addInputResolver(InputResolver<?> resolver) {
        inputResolvers.put(resolver.getType(), resolver);
    }

    public static Object resolveInput(String input) {
        int p = input.indexOf(58);
        if (p <= 0) {
            throw new IllegalArgumentException(input + " is not formatted using type:value");
        }
        String type = input.substring(0, p);
        String ref = input.substring(p + 1);
        InputResolver<?> ir = inputResolvers.get(type);
        if (ir != null) {
            return ir.getInput(ref);
        }
        JsonMarshaller marshaller = JsonRequestReader.marshalling().getMarshaller(type);
        if (marshaller == null) {
            throw new IllegalArgumentException("Cannot find resolver for " + type);
        }
        return marshaller.resolveReference(ref);
    }

    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return targetMediaType.isCompatible(arg3) && ExecutionRequest.class.isAssignableFrom(arg0);
    }

    public ExecutionRequest readFrom(Class<ExecutionRequest> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        return JsonRequestReader.readRequest(in, headers);
    }

    public static ExecutionRequest readRequest(InputStream in, MultivaluedMap<String, String> headers) throws IOException {
        String content = FileUtils.read((InputStream)in);
        return JsonRequestReader.readRequest(content, headers);
    }

    public static ExecutionRequest readRequest(String content, MultivaluedMap<String, String> headers) {
        String value;
        JSONObject object;
        String key;
        Iterator it;
        JSONObject json = JSONObject.fromObject((Object)content);
        String input = json.optString("input", null);
        JSONObject jsonParams = json.optJSONObject("params");
        JSONObject jsonContext = json.optJSONObject("context");
        String documentProperties = json.optString("documentProperties", null);
        if (documentProperties != null) {
            headers.putSingle((Object)"X-NXDocumentProperties", (Object)documentProperties);
        }
        Object inObj = null;
        if (input != null) {
            inObj = JsonRequestReader.resolveInput(input);
        }
        ExecutionRequest req = new ExecutionRequest(inObj);
        if (jsonParams != null) {
            it = jsonParams.keys();
            while (it.hasNext()) {
                key = (String)it.next();
                object = jsonParams.optJSONObject(key);
                if (object != null) {
                    req.setParam(key, object);
                    continue;
                }
                value = jsonParams.getString(key);
                req.setParam(key, value);
            }
        }
        if (jsonContext != null) {
            it = jsonContext.keys();
            while (it.hasNext()) {
                key = (String)it.next();
                object = jsonContext.optJSONObject(key);
                if (object != null) {
                    req.setContextParam(key, object);
                    continue;
                }
                value = jsonContext.getString(key);
                req.setContextParam(key, value);
            }
        }
        return req;
    }

    static {
        JsonRequestReader.addInputResolver(new DocumentInputResolver());
        JsonRequestReader.addInputResolver(new DocumentsInputResolver());
    }
}

