/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import com.sun.xml.ws.api.handler.MessageHandlerContext;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.ws.handler.MessageContext;
import org.apache.chemistry.opencmis.server.impl.webservices.AuthHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.opencmis.bindings.LoginProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.Authenticator;

public class NuxeoCmisAuthHandler
extends AuthHandler
implements LoginProvider {
    private static final Log log = LogFactory.getLog(NuxeoCmisAuthHandler.class);
    public static final String NUXEO_LOGIN_CONTEXT = "nuxeo.opencmis.LoginContext";
    public static final String LOGIN_PROVIDER_PROP = LoginProvider.class.getName();
    protected LoginProvider loginProvider;

    public boolean handleMessage(MessageHandlerContext context) {
        boolean res = super.handleMessage(context);
        Map callContextMap = (Map)context.get((Object)"org.apache.chemistry.opencmis.callcontext");
        if (callContextMap != null) {
            String username = (String)callContextMap.get("username");
            String password = (String)callContextMap.get("password");
            try {
                LoginContext loginContext = this.getLoginProvider().login(username, password);
                context.put((Object)NUXEO_LOGIN_CONTEXT, (Object)loginContext);
                context.setScope(NUXEO_LOGIN_CONTEXT, MessageContext.Scope.APPLICATION);
            }
            catch (LoginException e) {
                throw new RuntimeException("Login failed for user '" + username + "'", e);
            }
        }
        return res;
    }

    public void close(MessageContext context) {
        LoginContext loginContext = (LoginContext)context.get((Object)NUXEO_LOGIN_CONTEXT);
        if (loginContext != null) {
            try {
                loginContext.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Cannot logout", (Throwable)e);
            }
        }
        super.close(context);
    }

    protected LoginProvider getLoginProvider() {
        if (this.loginProvider == null) {
            this.loginProvider = this;
            String className = Framework.getProperty((String)LOGIN_PROVIDER_PROP);
            if (className != null) {
                try {
                    Object instance = Class.forName(className).newInstance();
                    if (instance instanceof LoginProvider) {
                        this.loginProvider = (LoginProvider)instance;
                    } else {
                        log.error((Object)(className + " is not an instance of " + LoginProvider.class.getName()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return this.loginProvider;
    }

    @Override
    public LoginContext login(String username, String password) {
        try {
            if (!this.getAuthenticator().checkUsernamePassword(username, password)) {
                throw new RuntimeException("Authentication failed for user '" + username + "'");
            }
            return Framework.login((String)username, (Object)password);
        }
        catch (Exception e) {
            throw new RuntimeException("Login failed for user '" + username + "'", e);
        }
    }

    protected Authenticator getAuthenticator() {
        Authenticator userManager;
        try {
            userManager = (Authenticator)Framework.getService(Authenticator.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get Authenticator service", e);
        }
        if (userManager == null) {
            throw new RuntimeException("Cannot get Authenticator service");
        }
        return userManager;
    }
}

