/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.SimpleResultSet;
import org.nuxeo.ecm.core.storage.sql.db.EmbeddedFunctions;

public class H2Functions
extends EmbeddedFunctions {
    private static final Log log = LogFactory.getLog(H2Functions.class);

    private static boolean isLogEnabled() {
        return false;
    }

    private static void logDebug(String message, Object ... args) {
        log.trace((Object)("SQL: " + String.format(message.replace("?", "%s"), args)));
    }

    public static boolean isInTreeString(Connection conn, String id, String baseId) throws SQLException {
        return H2Functions.isInTree(conn, (Serializable)((Object)id), (Serializable)((Object)baseId));
    }

    public static boolean isInTreeLong(Connection conn, Long id, Long baseId) throws SQLException {
        return H2Functions.isInTree(conn, id, baseId);
    }

    public static boolean isAccessAllowedString(Connection conn, String id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, (Serializable)((Object)id), H2Functions.split(principals), H2Functions.split(permissions));
    }

    public static boolean isAccessAllowedLong(Connection conn, Long id, String principals, String permissions) throws SQLException {
        return H2Functions.isAccessAllowed(conn, id, H2Functions.split(principals), H2Functions.split(permissions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clusterInvalidateString(Connection conn, String id, String fragments, int kind) throws SQLException {
        Statement ps = null;
        try {
            String sql = "SELECT \"NODEID\" FROM \"CLUSTER_NODES\" WHERE \"NODEID\" <> SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            ps = conn.prepareStatement(sql);
            LinkedList<Long> nodeIds = new LinkedList<Long>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                nodeIds.add(rs.getLong(1));
            }
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug("  -> " + nodeIds, new Object[0]);
            }
            sql = "INSERT INTO \"CLUSTER_INVALS\" (\"NODEID\", \"ID\", \"FRAGMENTS\", \"KIND\") VALUES (?, ?, ?, ?)";
            for (Long nodeId : nodeIds) {
                if (H2Functions.isLogEnabled()) {
                    H2Functions.logDebug(sql, nodeId, id, fragments, kind);
                }
                ps = conn.prepareStatement(sql);
                ps.setLong(1, nodeId);
                ps.setObject(2, id);
                ps.setString(3, fragments);
                ps.setInt(4, kind);
                ps.execute();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getClusterInvalidationsString(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("ID", 12, 0, 0);
        result.addColumn("FRAGMENTS", 12, 0, 0);
        result.addColumn("KIND", 4, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        Statement ps = null;
        Statement st = null;
        try {
            String sql = "SELECT \"ID\", \"FRAGMENTS\", \"KIND\" FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            ps = conn.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            LinkedList<String> debugValues = null;
            if (H2Functions.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            while (rs.next()) {
                String id = rs.getString(1);
                String fragments = rs.getString(2);
                long kind = rs.getLong(3);
                result.addRow(new Object[]{id, fragments, kind});
                if (debugValues == null) continue;
                debugValues.add(id + ',' + fragments + ',' + kind);
            }
            if (debugValues != null) {
                H2Functions.logDebug("  -> " + debugValues, new Object[0]);
            }
            sql = "DELETE FROM \"CLUSTER_INVALS\" WHERE \"NODEID\" = SESSION_ID()";
            if (H2Functions.isLogEnabled()) {
                H2Functions.logDebug(sql, new Object[0]);
            }
            st = conn.createStatement();
            st.execute(sql);
            SimpleResultSet simpleResultSet = result;
            return simpleResultSet;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet upgradeVersions(Connection conn) throws SQLException {
        PreparedStatement ps1 = null;
        Statement ps2 = null;
        try {
            String sql = "SELECT v.id, v.versionableid, h.majorversion, h.minorversion  FROM versions v JOIN hierarchy h ON v.id = h.id  ORDER BY v.versionableid, v.created DESC";
            ps1 = conn.prepareStatement(sql);
            ResultSet rs = ps1.executeQuery();
            String series = null;
            boolean isLatest = false;
            boolean isLatestMajor = false;
            while (rs.next()) {
                String id = rs.getString("id");
                String vid = rs.getString("versionableid");
                long maj = rs.getLong("majorversion");
                long min = rs.getLong("minorversion");
                if (vid == null || !vid.equals(series)) {
                    isLatest = true;
                    isLatestMajor = true;
                    series = vid;
                }
                boolean isMajor = min == 0L;
                ps2 = conn.prepareStatement("UPDATE versions SET label = ?, islatest = ?, islatestmajor = ? WHERE id = ?");
                ps2.setString(1, maj + "." + min);
                ps2.setBoolean(2, isLatest);
                ps2.setBoolean(3, isMajor && isLatestMajor);
                ps2.setString(4, id);
                ps2.executeUpdate();
                isLatest = false;
                if (!isMajor) continue;
                isLatestMajor = false;
            }
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
        }
        return new SimpleResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet upgradeLastContributor(Connection conn) throws SQLException {
        PreparedStatement ps1 = null;
        Statement ps2 = null;
        try {
            String sql = "SELECT dc_c.id, dc_c.item  FROM dublincore dc    JOIN (SELECT id, max(pos) AS pos FROM dc_contributors GROUP BY id) AS tmp ON (dc.id = tmp.id)    JOIN dc_contributors dc_c ON (tmp.id = dc_c.id AND tmp.pos = dc_c.pos)  WHERE dc.lastContributor IS NULL;";
            ps1 = conn.prepareStatement(sql);
            ResultSet rs = ps1.executeQuery();
            Object series = null;
            while (rs.next()) {
                String id = rs.getString("id");
                String lastContributor = rs.getString("item");
                ps2 = conn.prepareStatement("UPDATE dublincore SET lastContributor = ? WHERE id = ?");
                ps2.setString(1, lastContributor);
                ps2.setString(2, id);
                ps2.executeUpdate();
            }
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
        }
        return new SimpleResultSet();
    }
}

