/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.adapters.PropertyWrapper;

public class SchemaTemplate
extends PropertyWrapper
implements TemplateHashModel {
    private final DocumentModel doc;
    private final String schemaName;

    public SchemaTemplate(DocumentObjectWrapper wrapper, DocumentSchema schema) {
        super(wrapper);
        this.doc = schema.doc;
        this.schemaName = schema.schemaName;
    }

    public TemplateModel get(String name) throws TemplateModelException {
        try {
            Field prefetchField = DocumentModelImpl.class.getDeclaredField("prefetch");
            prefetchField.setAccessible(true);
            Map prefetch = (Map)prefetchField.get(this.doc);
            if (prefetch != null && prefetch.containsKey(this.schemaName + '.' + name)) {
                return this.wrapper.wrap(this.doc.getProperty(this.schemaName, name));
            }
            return this.wrap(this.doc.getPart(this.schemaName).get(name));
        }
        catch (ClientException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new TemplateModelException(e);
        }
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public static class DocumentSchema {
        public final DocumentModel doc;
        public final String schemaName;

        public DocumentSchema(DocumentModel doc, String schemaName) {
            this.doc = doc;
            this.schemaName = schemaName;
        }
    }
}

