/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.listener;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.comment.listener.AbstractCommentListener;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

public class CommentRemovedEventListener
extends AbstractCommentListener
implements EventListener {
    private static final Log log = LogFactory.getLog(CommentRemovedEventListener.class);

    @Override
    protected void doProcess(CoreSession coreSession, RelationManager relationManager, CommentServiceConfig config, DocumentModel docMessage) throws Exception {
        log.debug((Object)"Processing relations cleanup on Comment removal");
        String typeName = docMessage.getType();
        if ("Comment".equals(typeName) || "Post".equals(typeName)) {
            CommentRemovedEventListener.onCommentRemoved(relationManager, config, docMessage);
        }
    }

    private static void onCommentRemoved(RelationManager relationManager, CommentServiceConfig config, DocumentModel docModel) throws ClientException {
        Resource commentRes = relationManager.getResource(config.commentNamespace, (Serializable)docModel, null);
        if (commentRes == null) {
            log.warn((Object)"Could not adapt document model to relation resource; check the service relation adapters configuration");
            return;
        }
        StatementImpl pattern = new StatementImpl((Node)commentRes, null, null);
        List statementList = relationManager.getStatements(config.graphName, (Statement)pattern);
        relationManager.remove(config.graphName, statementList);
    }
}

