/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.ejb;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.api.remote.LogsRemote;
import org.nuxeo.ecm.platform.audit.ejb.local.LogsLocal;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={LogsLocal.class})
@Remote(value={LogsRemote.class})
public class LogsBean
implements Logs {
    @PersistenceContext(unitName="nxaudit-logs")
    private EntityManager em;

    protected NXAuditEventsService service() {
        return (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
    }

    public void addLogEntries(List<LogEntry> entries) {
        this.service().addLogEntries(this.em, entries);
    }

    public List<LogEntry> getLogEntriesFor(String uuid) {
        List entries = this.service().getLogEntriesFor(this.em, uuid);
        return this.mkSerializable(entries);
    }

    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        List entries = this.service().getLogEntriesFor(this.em, uuid, filterMap, doDefaultSort);
        return this.mkSerializable(entries);
    }

    public List<LogEntry> nativeQueryLogs(String whereClause, int pageNb, int pageSize) {
        List entries = this.service().nativeQueryLogs(this.em, whereClause, pageNb, pageSize);
        return this.mkSerializable(entries);
    }

    public List<?> nativeQuery(String query, int pageNb, int pageSize) {
        List entries = this.service().nativeQuery(this.em, query, pageNb, pageSize);
        return entries;
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        List entries = this.service().nativeQuery(this.em, query, params, pageNb, pageSize);
        return entries;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        List entries = this.service().queryLogsByPage(this.em, eventIds, limit, category, path, pageNb, pageSize);
        return this.mkSerializable(entries);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        List entries = this.service().queryLogsByPage(this.em, eventIds, dateRange, category, path, pageNb, pageSize);
        return this.mkSerializable(entries);
    }

    public List<LogEntry> queryLogs(String[] eventIds, String dateRange) {
        List entries = this.service().queryLogs(this.em, eventIds, dateRange);
        return this.mkSerializable(entries);
    }

    public LogEntry getLogEntryByID(long id) {
        LogEntry entry = this.service().getLogEntryByID(this.em, id);
        return this.mkSerializable(entry);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.service().syncLogCreationEntries(this.em, repoId, path, recurs);
    }

    public void logEvent(Event event) throws AuditException {
        this.service().logEvent(this.em, event);
    }

    public void logEvents(EventBundle eventBundle) throws AuditException {
        this.service().logEvents(this.em, eventBundle);
    }

    protected List<LogEntry> mkSerializable(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            Map ext = entry.getExtendedInfos();
            if (ext == null || ext.isEmpty()) {
                entry.setExtendedInfos(null);
                continue;
            }
            entry.setExtendedInfos(new HashMap(ext));
        }
        return entries;
    }

    protected LogEntry mkSerializable(LogEntry entry) {
        Map ext = entry.getExtendedInfos();
        if (ext == null || ext.isEmpty()) {
            entry.setExtendedInfos(null);
        } else {
            entry.setExtendedInfos(new HashMap(ext));
        }
        return entry;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        List entries = this.service().queryLogsByPage(this.em, eventIds, dateRange, categories, path, pageNb, pageSize);
        return this.mkSerializable(entries);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        List entries = this.service().queryLogsByPage(this.em, eventIds, limit, categories, path, pageNb, pageSize);
        return this.mkSerializable(entries);
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return this.service().newExtendedInfo(value);
    }

    public LogEntry newLogEntry() {
        return this.service().newLogEntry();
    }
}

