/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.doc;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.runtime.api.Framework;

public class JSONExporter {
    private JSONExporter() {
    }

    public static String toJSON() throws Exception {
        return JSONExporter.toJSON(((AutomationService)Framework.getService(AutomationService.class)).getDocumentation());
    }

    public static void toJSON(Writer writer) throws Exception {
        JSONExporter.toJSON(((AutomationService)Framework.getService(AutomationService.class)).getDocumentation(), writer);
    }

    public static String toJSON(List<OperationDocumentation> docs) throws IOException {
        StringWriter writer = new StringWriter();
        JSONExporter.toJSON(docs, writer);
        return writer.toString();
    }

    public static void toJSON(List<OperationDocumentation> docs, Writer writer) throws IOException {
        JSONObject json = new JSONObject();
        JSONArray ops = new JSONArray();
        for (OperationDocumentation doc : docs) {
            JSONObject op = JSONExporter.toJSON(doc);
            ops.add((Object)op);
        }
        json.element("operations", (Collection)ops);
        writer.write(json.toString(2));
    }

    public static JSONObject toJSON(OperationDocumentation doc) {
        JSONObject op = new JSONObject();
        op.element("id", (Object)doc.id);
        op.element("label", (Object)doc.label);
        op.element("category", (Object)doc.category);
        op.element("requires", (Object)doc.requires);
        op.element("description", (Object)doc.description);
        if (doc.since != null && doc.since.length() > 0) {
            op.element("since", (Object)doc.since);
        }
        op.element("url", (Object)doc.url);
        JSONArray sig = new JSONArray();
        for (String in : doc.signature) {
            sig.add((Object)in);
        }
        op.element("signature", (Collection)sig);
        JSONArray params = new JSONArray();
        for (OperationDocumentation.Param p : doc.params) {
            JSONObject param = new JSONObject();
            param.element("name", (Object)p.name);
            param.element("type", (Object)p.type);
            param.element("required", p.isRequired);
            param.element("widget", (Object)p.widget);
            param.element("order", p.order);
            JSONArray ar = new JSONArray();
            for (String value : p.values) {
                ar.add((Object)value);
            }
            param.element("values", (Collection)ar);
            params.add((Object)param);
        }
        op.element("params", (Collection)params);
        return op;
    }

    public static OperationDocumentation fromJSON(JSONObject json) {
        JSONArray params;
        OperationDocumentation op = new OperationDocumentation(json.getString("id"));
        op.category = json.optString("label", null);
        op.category = json.optString("category", null);
        op.requires = json.optString("requires", null);
        op.description = json.optString("description", null);
        op.url = json.optString("url", op.id);
        JSONArray sig = json.optJSONArray("signature");
        if (sig != null) {
            op.signature = new String[sig.size()];
            int size = sig.size();
            for (int j = 0; j < size; ++j) {
                op.signature[j] = sig.getString(j);
            }
        }
        if ((params = json.optJSONArray("params")) != null) {
            op.params = new ArrayList<OperationDocumentation.Param>(params.size());
            int size = params.size();
            for (int j = 0; j < size; ++j) {
                JSONObject p = params.getJSONObject(j);
                OperationDocumentation.Param para = new OperationDocumentation.Param();
                para.name = p.optString("name", null);
                para.type = p.optString("type", null);
                para.isRequired = p.optBoolean("required", false);
                para.widget = p.optString("widget", null);
                para.order = p.optInt("order", 0);
                JSONArray ar = p.optJSONArray("values");
                if (ar != null) {
                    para.values = new String[ar.size()];
                    int size2 = ar.size();
                    for (int k = 0; k < size2; ++k) {
                        para.values[k] = ar.getString(k);
                    }
                }
                op.params.add(para);
            }
        }
        return op;
    }
}

