/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelListCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.MultiPublish", category="Document", label="Multi-Publish", description="Publish the input document(s) into several target sections. The target is evaluated to a document list (can be a path, UID or EL expression). Existing proxy is overrided if the override attribute is set. Returns a list with the created proxies.")
public class MultiPublishDocument {
    public static final String ID = "Document.MultiPublish";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentModelList target;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;

    @OperationMethod(collector=DocumentModelListCollector.class)
    public DocumentModelList run(DocumentModel doc) throws Exception {
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (DocumentModel t : this.target) {
            docs.add((Object)this.session.publishDocument(doc, t, this.override));
        }
        return docs;
    }
}

