/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.AbstractExecutor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;

public class ShellExecutor
extends AbstractExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(ShellExecutor.class);

    @Override
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params) {
        Process p1;
        long t0 = System.currentTimeMillis();
        ArrayList<String> output = new ArrayList<String>();
        String paramString = ShellExecutor.getParametersString(cmdDesc, params);
        if (!ShellExecutor.isWindows()) {
            paramString = paramString + " 2>&1";
        }
        Object[] cmd = new String[]{"/bin/sh", "-c", cmdDesc.getCommand() + " " + paramString};
        if (ShellExecutor.isWindows()) {
            cmd[0] = "cmd";
            cmd[1] = "/C";
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running system command: " + StringUtils.join((Object[])cmd, (String)" ")));
            }
            p1 = Runtime.getRuntime().exec((String[])cmd);
        }
        catch (IOException e) {
            return new ExecResult(e);
        }
        if (cmdDesc.getReadOutput()) {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            try {
                String strLine;
                while ((strLine = stdInput.readLine()) != null) {
                    output.add(strLine);
                }
            }
            catch (IOException e) {
                return new ExecResult(e);
            }
        }
        int exitCode = 0;
        try {
            exitCode = p1.waitFor();
        }
        catch (InterruptedException e) {
            return new ExecResult(e);
        }
        long t1 = System.currentTimeMillis();
        return new ExecResult(output, t1 - t0, exitCode);
    }
}

