/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.data;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.marshaling.JSONExportMethod;
import org.nuxeo.connect.data.marshaling.JSONExportableField;
import org.nuxeo.connect.data.marshaling.JSONImportMethod;
import org.nuxeo.connect.update.NuxeoValidationState;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.ProductionState;
import org.nuxeo.connect.update.Version;

public class PackageDescriptor
extends AbstractJSONSerializableData
implements DownloadablePackage {
    @JSONExportableField
    protected String homePage;
    @JSONExportableField
    protected String classifier;
    @JSONExportableField
    protected String description;
    @JSONExportableField
    protected String name;
    @JSONExportableField
    protected String vendor;
    @JSONExportableField
    protected int state;
    @JSONExportableField
    protected String license;
    @JSONExportableField
    protected String licenseUrl;
    @JSONExportableField
    protected String[] targetPlatforms;
    protected PackageDependency[] dependencies;
    @JSONExportableField
    protected String title;
    @JSONExportableField
    protected PackageType type;
    @JSONExportableField
    protected Version version;
    @JSONExportableField
    protected String sourceDigest;
    @JSONExportableField
    protected String sourceUrl;
    @JSONExportableField
    protected long sourceSize;
    @JSONExportableField
    protected int commentsNumber;
    @JSONExportableField
    protected String pictureUrl;
    @JSONExportableField
    protected int downloadsCount;
    @JSONExportableField
    protected int rating;
    @JSONExportableField
    protected ProductionState productionState;
    @JSONExportableField
    protected NuxeoValidationState nuxeoValidationState;
    @JSONExportableField
    protected boolean supported;
    @JSONExportableField
    protected boolean supportsHotReload;

    @JSONExportMethod(name="dependencies")
    protected JSONArray getDependenciesAsJSON() {
        JSONArray deps = new JSONArray();
        for (PackageDependency dep : this.getDependencies()) {
            deps.put((Object)dep.toString());
        }
        return deps;
    }

    @JSONImportMethod(name="dependencies")
    protected void setDependenciesAsJSON(JSONArray array) throws JSONException {
        PackageDependency[] deps = new PackageDependency[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            deps[i] = new PackageDependency(array.getString(i));
        }
        this.setDependencies(deps);
    }

    @JSONImportMethod(name="targetPlatforms")
    public void setTargetPlatformsAsJSON(JSONArray array) throws JSONException {
        String[] targets = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            targets[i] = array.getString(i);
        }
        this.targetPlatforms = targets;
    }

    @JSONImportMethod(name="type")
    public void setTypeAsJSON(String strType) {
        this.type = PackageType.getByValue(strType);
    }

    @JSONImportMethod(name="version")
    public void setVersionAsJSON(String v) {
        this.version = new Version(v);
    }

    @JSONImportMethod(name="productionState")
    public void setProductionStateAsJSON(String state) {
        this.productionState = ProductionState.getByValue(state);
    }

    @JSONImportMethod(name="nuxeoValidationState")
    public void setNuxeoValidationStateAsJSON(String state) {
        this.nuxeoValidationState = NuxeoValidationState.getByValue(state);
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setCommentsNumber(int commentsNumber) {
        this.commentsNumber = commentsNumber;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public void setDownloadsCount(int downloadsCount) {
        this.downloadsCount = downloadsCount;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    @Override
    public String getHomePage() {
        return this.homePage;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        if (this.getVersion() == null) {
            return this.getName();
        }
        return this.getName() + "-" + this.getVersion();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public String getLicenseType() {
        return this.license;
    }

    @Override
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @Override
    public String[] getTargetPlatforms() {
        return this.targetPlatforms;
    }

    @Override
    public PackageDependency[] getDependencies() {
        if (this.dependencies == null) {
            return new PackageDependency[0];
        }
        return this.dependencies;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String getSourceDigest() {
        return this.sourceDigest;
    }

    @Override
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    public long getSourceSize() {
        return this.sourceSize;
    }

    @Deprecated
    public static PackageDescriptor loadFromJSON(JSONObject json) throws JSONException {
        return PackageDescriptor.loadFromJSON(PackageDescriptor.class, json);
    }

    @Deprecated
    public static PackageDescriptor loadFromJSON(String json) throws JSONException {
        return PackageDescriptor.loadFromJSON(new JSONObject(json));
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetPlatforms(List<String> targetPlatforms) {
        this.targetPlatforms = targetPlatforms == null ? new String[]{} : targetPlatforms.toArray(new String[targetPlatforms.size()]);
    }

    public void setTargetPlatforms(String[] targetPlatforms) {
        this.targetPlatforms = targetPlatforms;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(PackageType type) {
        this.type = type;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setSourceDigest(String sourceDigest) {
        this.sourceDigest = sourceDigest;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public void setSourceSize(long sourceSize) {
        this.sourceSize = sourceSize;
    }

    public void setDependencies(PackageDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public String getDependenciesAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.dependencies == null || this.dependencies.length == 0) {
            return "";
        }
        for (PackageDependency dep : this.getDependencies()) {
            sb.append(dep.toString());
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public int getCommentsNumber() {
        return this.commentsNumber;
    }

    @Override
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public int getDownloadsCount() {
        return this.downloadsCount;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public ProductionState getProductionState() {
        if (this.productionState == null) {
            return ProductionState.TESTING;
        }
        return this.productionState;
    }

    @Override
    public NuxeoValidationState getValidationState() {
        if (this.nuxeoValidationState == null) {
            return NuxeoValidationState.NONE;
        }
        return this.nuxeoValidationState;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public boolean supportsHotReload() {
        return this.supportsHotReload;
    }

    public void setProductionState(ProductionState productionState) {
        this.productionState = productionState;
    }

    public void setNuxeoValidationState(NuxeoValidationState nuxeoValidationState) {
        this.nuxeoValidationState = nuxeoValidationState;
    }

    public void setSupported(boolean supported) {
        this.supported = supported;
    }

    public void setSupportsHotReload(boolean supportsHotReload) {
        this.supportsHotReload = supportsHotReload;
    }
}

