/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpClientCall;
import com.noelios.restlet.http.HttpClientHelper;
import com.noelios.restlet.http.HttpConverter;
import com.noelios.restlet.util.CookieReader;
import com.noelios.restlet.util.CookieUtils;
import com.noelios.restlet.util.HeaderReader;
import com.noelios.restlet.util.PreferenceUtils;
import com.noelios.restlet.util.SecurityUtils;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Dimension;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

public class HttpClientConverter
extends HttpConverter {
    public HttpClientConverter(Context context) {
        super(context);
    }

    public HttpClientCall toSpecific(HttpClientHelper client, Request request) {
        HttpClientCall result = client.create(request);
        this.addRequestHeaders(result, request);
        return result;
    }

    public void commit(HttpClientCall httpCall, Request request, Response response) {
        if (httpCall != null) {
            response.setStatus(httpCall.sendRequest(request));
            response.getServerInfo().setAddress(httpCall.getServerAddress());
            response.getServerInfo().setPort(httpCall.getServerPort());
            this.readResponseHeaders(httpCall, response);
            response.setEntity(httpCall.getResponseEntity());
        }
    }

    protected void addRequestHeaders(HttpClientCall httpCall, Request request) {
        if (httpCall != null) {
            ClientInfo client;
            int i;
            Reference hostRef;
            Series<Parameter> requestHeaders = httpCall.getRequestHeaders();
            Reference reference = hostRef = request.getResourceRef().getBaseRef() != null ? request.getResourceRef().getBaseRef() : request.getResourceRef();
            if (hostRef.getHostDomain() != null) {
                String host = hostRef.getHostDomain();
                int hostRefPortValue = hostRef.getHostPort();
                if (hostRefPortValue != -1 && hostRefPortValue != request.getProtocol().getDefaultPort()) {
                    host = host + ':' + hostRefPortValue;
                }
                requestHeaders.add("Host", host);
            }
            if (request.getClientInfo().getAgent() != null) {
                requestHeaders.add("User-Agent", request.getClientInfo().getAgent());
            } else {
                requestHeaders.add("User-Agent", "Noelios-Restlet-Engine/1.0.6");
            }
            Conditions condition = request.getConditions();
            if (condition.getMatch() != null) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getMatch().get(i).format());
                }
                httpCall.getRequestHeaders().add("If-Match", value.toString());
            }
            if (condition.getModifiedSince() != null) {
                String imsDate = DateUtils.format(condition.getModifiedSince(), DateUtils.FORMAT_RFC_1123.get(0));
                requestHeaders.add("If-Modified-Since", imsDate);
            }
            if (condition.getNoneMatch() != null) {
                StringBuilder value = new StringBuilder();
                for (i = 0; i < condition.getNoneMatch().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(condition.getNoneMatch().get(i).format());
                }
                requestHeaders.add("If-None-Match", value.toString());
            }
            if (condition.getUnmodifiedSince() != null) {
                String iusDate = DateUtils.format(condition.getUnmodifiedSince(), DateUtils.FORMAT_RFC_1123.get(0));
                requestHeaders.add("If-Unmodified-Since", iusDate);
            }
            if (request.getCookies().size() > 0) {
                String cookies = CookieUtils.format(request.getCookies());
                requestHeaders.add("Cookie", cookies);
            }
            if (request.getReferrerRef() != null) {
                requestHeaders.add("Referer", request.getReferrerRef().toString());
            }
            if ((client = request.getClientInfo()).getAcceptedMediaTypes().size() > 0) {
                try {
                    requestHeaders.add("Accept", PreferenceUtils.format(client.getAcceptedMediaTypes()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            } else {
                requestHeaders.add("Accept", MediaType.ALL.getName());
            }
            if (client.getAcceptedCharacterSets().size() > 0) {
                try {
                    requestHeaders.add("Accept-Charset", PreferenceUtils.format(client.getAcceptedCharacterSets()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedEncodings().size() > 0) {
                try {
                    requestHeaders.add("Accept-Encoding", PreferenceUtils.format(client.getAcceptedEncodings()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (client.getAcceptedLanguages().size() > 0) {
                try {
                    requestHeaders.add("Accept-Language", PreferenceUtils.format(client.getAcceptedLanguages()));
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
                }
            }
            if (request.getEntity() != null) {
                int i2;
                if (request.getEntity().getMediaType() != null) {
                    String contentType = request.getEntity().getMediaType().toString();
                    if (request.getEntity().getMediaType().getParameters().getFirstValue("charset") == null && request.getEntity().getCharacterSet() != null) {
                        contentType = contentType + "; charset=" + request.getEntity().getCharacterSet().getName();
                    }
                    requestHeaders.add("Content-Type", contentType);
                }
                if (!request.getEntity().getEncodings().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getEncodings().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getEncodings().get(i2).getName());
                    }
                    requestHeaders.add("Content-Encoding", value.toString());
                }
                if (!request.getEntity().getLanguages().isEmpty()) {
                    StringBuilder value = new StringBuilder();
                    for (i2 = 0; i2 < request.getEntity().getLanguages().size(); ++i2) {
                        if (i2 > 0) {
                            value.append(", ");
                        }
                        value.append(request.getEntity().getLanguages().get(i2).getName());
                    }
                    requestHeaders.add("Content-Language", value.toString());
                }
            }
            Series additionalHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
            this.addAdditionalHeaders(requestHeaders, additionalHeaders);
            ChallengeResponse challengeResponse = request.getChallengeResponse();
            if (challengeResponse != null) {
                requestHeaders.add("Authorization", SecurityUtils.format(challengeResponse, request, requestHeaders));
            }
        }
    }

    protected void readResponseHeaders(HttpClientCall httpCall, Response response) {
        try {
            response.getAttributes().put("org.restlet.http.headers", httpCall.getResponseHeaders());
            for (Parameter header : httpCall.getResponseHeaders()) {
                String value;
                HeaderReader hr;
                if (header.getName().equalsIgnoreCase("Location")) {
                    response.setRedirectRef(header.getValue());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                    try {
                        CookieReader cr = new CookieReader(this.getLogger(), header.getValue());
                        response.getCookieSettings().add(cr.readCookieSetting());
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.WARNING, "Error during cookie setting parsing. Header: " + header.getValue(), e);
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("WWW-Authenticate")) {
                    ChallengeRequest request = SecurityUtils.parseRequest(header.getValue());
                    response.setChallengeRequest(request);
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Server")) {
                    response.getServerInfo().setAgent(header.getValue());
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Allow")) {
                    hr = new HeaderReader(header.getValue());
                    value = hr.readValue();
                    Set<Method> allowedMethods = response.getAllowedMethods();
                    while (value != null) {
                        allowedMethods.add(Method.valueOf(value));
                        value = hr.readValue();
                    }
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Vary")) continue;
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                Set<Dimension> dimensions = response.getDimensions();
                while (value != null) {
                    if (value.equalsIgnoreCase("Accept")) {
                        dimensions.add(Dimension.MEDIA_TYPE);
                    } else if (value.equalsIgnoreCase("Accept-Charset")) {
                        dimensions.add(Dimension.CHARACTER_SET);
                    } else if (value.equalsIgnoreCase("Accept-Encoding")) {
                        dimensions.add(Dimension.ENCODING);
                    } else if (value.equalsIgnoreCase("Accept-Language")) {
                        dimensions.add(Dimension.LANGUAGE);
                    } else if (value.equalsIgnoreCase("User-Agent")) {
                        dimensions.add(Dimension.CLIENT_AGENT);
                    } else if (value.equals("*")) {
                        dimensions.add(Dimension.UNSPECIFIED);
                    }
                    value = hr.readValue();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "An error occured during the processing of the HTTP response.", e);
            response.setStatus(new Status(Status.CONNECTOR_ERROR_INTERNAL, "Unable to process the response. " + e.getMessage()));
        }
    }
}

