/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.plugins.deployers.BasicStatistic;
import org.jboss.deployers.plugins.deployers.DeployerStatistic;

class DeployerStatistics {
    private Map<String, DeployerStatistic> deployers = new ConcurrentHashMap<String, DeployerStatistic>();

    DeployerStatistics() {
    }

    public synchronized void addStatistic(String deployerName, String unitName, long time) {
        DeployerStatistic stat = this.deployers.get(deployerName);
        if (stat == null) {
            stat = new DeployerStatistic(deployerName);
            this.deployers.put(deployerName, stat);
        }
        stat.addDetail(unitName, time);
    }

    public String listTimes(boolean details) {
        ArrayList<DeployerStatistic> stats = new ArrayList<DeployerStatistic>(this.deployers.values());
        Collections.sort(stats);
        StringBuilder builder = new StringBuilder();
        builder.append("<table><tr><th>Deployer/Deployment</th><th>Time (milliseconds)</th></tr>");
        for (DeployerStatistic stat : stats) {
            builder.append("<tr>");
            builder.append("<td>").append(stat.getName()).append("</td>");
            builder.append("<td>").append(stat.getTime()).append("</td>");
            builder.append("</tr>");
            if (!details) continue;
            ArrayList<BasicStatistic> list = new ArrayList<BasicStatistic>(stat.getDetails().values());
            Collections.sort(list);
            for (BasicStatistic detail : list) {
                builder.append("<tr>");
                builder.append("<td>`-- ").append(detail.getName()).append("</td>");
                builder.append("<td>").append(detail.getTime()).append("</td>");
                builder.append("</tr>");
            }
        }
        builder.append("</table>");
        return builder.toString();
    }
}

