/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.ejb;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.io.api.IOManager;
import org.nuxeo.ecm.platform.io.api.IOResourceAdapter;
import org.nuxeo.ecm.platform.io.api.ejb.IOManagerLocal;
import org.nuxeo.ecm.platform.io.api.ejb.IOManagerRemote;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={IOManagerLocal.class})
@Remote(value={IOManagerRemote.class})
public class IOManagerBean
implements IOManager {
    private static final long serialVersionUID = 5868307995104155402L;
    private static final Log log = LogFactory.getLog(IOManagerBean.class);
    private IOManager service;

    @PostConstruct
    public void initialize() {
        try {
            this.service = (IOManager)Framework.getLocalService(IOManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get IOManager service", (Throwable)e);
        }
    }

    public void remove() {
    }

    public void addAdapter(String name, IOResourceAdapter adapter) throws ClientException {
        try {
            this.service.addAdapter(name, adapter);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public Collection<DocumentRef> copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        try {
            return this.service.copyDocumentsAndResources(repo, sources, targetLocation, ioAdapters);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void exportDocumentsAndResources(OutputStream out, String repo, Collection<DocumentRef> sources, boolean recurse, String format, Collection<String> ioAdapters) throws ClientException {
        try {
            this.service.exportDocumentsAndResources(out, repo, sources, false, format, ioAdapters);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public IOResourceAdapter getAdapter(String name) throws ClientException {
        try {
            return this.service.getAdapter(name);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void importDocumentsAndResources(InputStream in, String repo, DocumentRef root) throws ClientException {
        try {
            this.service.importDocumentsAndResources(in, repo, root);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void removeAdapter(String name) throws ClientException {
        try {
            this.service.removeAdapter(name);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, String serverAddress, int rmiPort, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        try {
            this.service.copyDocumentsAndResources(repo, sources, serverAddress, rmiPort, targetLocation, ioAdapters);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void importExportedFile(String uri, DocumentLocation targetLocation) throws ClientException {
        try {
            this.service.importExportedFile(uri, targetLocation);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, String serverAddress, int jndiPort, DocumentLocation targetLocation, String docReaderFactoryName, Map<String, Object> rFactoryParams, String docWriterFactoryName, Map<String, Object> wFactoryParams, Collection<String> ioAdapters) throws ClientException {
        try {
            this.service.copyDocumentsAndResources(repo, sources, serverAddress, jndiPort, targetLocation, docReaderFactoryName, rFactoryParams, docWriterFactoryName, wFactoryParams, ioAdapters);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void importExportedFile(String uri, DocumentLocation targetLocation, String docWriterFactoryName, Map<String, Object> wFactoryParams) throws ClientException {
        try {
            this.service.importExportedFile(uri, targetLocation, docWriterFactoryName, wFactoryParams);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void copyDocumentsAndResources(String repo, Collection<DocumentRef> sources, IOManager remoteIOManager, DocumentLocation targetLocation, Collection<String> ioAdapters) throws ClientException {
        try {
            this.service.copyDocumentsAndResources(repo, sources, remoteIOManager, targetLocation, ioAdapters);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String externalizeExport(String repo, Collection<DocumentRef> sources, Collection<String> ioAdapters) throws ClientException {
        try {
            String uri = this.service.externalizeExport(repo, sources, ioAdapters);
            return uri;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String externalizeExport(String repo, String docReaderFactoryName, Map<String, Object> readerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        try {
            String uri = this.service.externalizeExport(repo, docReaderFactoryName, readerFactoryParams, ioAdapters);
            return uri;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String externalizeExport(String repo, Collection<DocumentRef> sources, String docReaderFactoryName, Map<String, Object> readerFactoryParams, Collection<String> ioAdapters) throws ClientException {
        try {
            String uri = this.service.externalizeExport(repo, sources, docReaderFactoryName, readerFactoryParams, ioAdapters);
            return uri;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void disposeExport(String uri) throws ClientException {
        try {
            this.service.disposeExport(uri);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void importFromStreamSource(String uri, DocumentLocation targetLocation, String docReaderFactoryClassName, Map<String, Object> rFactoryParams, String docWriterFactoryClassName, Map<String, Object> wFactoryParams) throws ClientException {
        try {
            this.service.importFromStreamSource(uri, targetLocation, docReaderFactoryClassName, rFactoryParams, docWriterFactoryClassName, wFactoryParams);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void importFromStream(InputStream in, DocumentLocation targetLocation, String docReaderFactoryClassName, Map<String, Object> rFactoryParams, String docWriterFactoryClassName, Map<String, Object> wFactoryParams) throws ClientException {
        try {
            this.service.importFromStream(in, targetLocation, docReaderFactoryClassName, rFactoryParams, docWriterFactoryClassName, wFactoryParams);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }
}

