/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.jmock.core.Formatting;
import org.jmock.core.SelfDescribing;

public class Invocation
implements SelfDescribing {
    public final Object invokedObject;
    public final Method invokedMethod;
    public final List parameterValues;
    private static final Map BOX_TYPES = Invocation.makeBoxTypesMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public Invocation(Object invoked, Method method, Object[] parameterValues) {
        this.invokedObject = invoked;
        this.invokedMethod = method;
        this.parameterValues = parameterValues == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(Arrays.asList(parameterValues));
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean equals(Object other) {
        return other instanceof Invocation && this.equals((Invocation)other);
    }

    public boolean equals(Invocation other) {
        return other != null && this.invokedObject == other.invokedObject && this.invokedMethod.equals(other.invokedMethod) && ((Object)this.parameterValues).equals(other.parameterValues);
    }

    public int hashCode() {
        return this.invokedObject.hashCode() ^ this.invokedMethod.hashCode() ^ ((Object)this.parameterValues).hashCode();
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append(this.invokedObject.toString()).append(".").append(this.invokedMethod.getName());
        Formatting.join(this.parameterValues, buffer, "(", ")");
        return buffer;
    }

    public void checkReturnTypeCompatibility(Object result) {
        Class<?> returnType = this.invokedMethod.getReturnType();
        if (returnType == Void.TYPE) {
            this.failIfReturnTypeIsNotNull(result);
        } else if (result == null) {
            this.failIfReturnTypeIsPrimitive();
        } else {
            Class<?> valueType = result.getClass();
            if (!this.isCompatible(returnType, valueType)) {
                this.reportTypeError(returnType, valueType);
            }
        }
    }

    private boolean isCompatible(Class returnType, Class valueType) {
        if (returnType.isPrimitive()) {
            return this.isBoxedType(returnType, valueType);
        }
        return returnType.isAssignableFrom(valueType);
    }

    private boolean isBoxedType(Class primitiveType, Class referenceType) {
        return BOX_TYPES.get(primitiveType) == referenceType;
    }

    private void failIfReturnTypeIsNotNull(Object result) {
        Assert.assertNull((String)"tried to return a value from a void method", (Object)result);
    }

    private void failIfReturnTypeIsPrimitive() {
        Class<?> returnType = this.invokedMethod.getReturnType();
        Assert.assertFalse((String)("tried to return null value from method returning " + returnType.getName()), (boolean)returnType.isPrimitive());
    }

    private void reportTypeError(Class returnType, Class valueType) {
        Assert.fail((String)("tried to return an incompatible value: expected a " + returnType.getName() + " but returned a " + valueType.getName()));
    }

    private static Map makeBoxTypesMap() {
        HashMap<Class<Comparable<Boolean>>, Class> map = new HashMap<Class<Comparable<Boolean>>, Class>();
        map.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Invocation.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        map.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Invocation.class$("java.lang.Byte")) : class$java$lang$Byte);
        map.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Invocation.class$("java.lang.Character")) : class$java$lang$Character);
        map.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Invocation.class$("java.lang.Short")) : class$java$lang$Short);
        map.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Invocation.class$("java.lang.Integer")) : class$java$lang$Integer);
        map.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Invocation.class$("java.lang.Long")) : class$java$lang$Long);
        map.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Invocation.class$("java.lang.Float")) : class$java$lang$Float);
        map.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Invocation.class$("java.lang.Double")) : class$java$lang$Double);
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

