/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="filterConfig")
public class FilterConfigDescriptor
implements Serializable {
    public static final String DEFAULT_CACHE_DURATION = "3599";
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@synchonize")
    protected boolean useSync;
    @XNode(value="@transactional")
    protected boolean useTx;
    @XNode(value="@buffered")
    protected boolean useTxBuffered = true;
    @XNode(value="@cached")
    protected boolean cached;
    @XNode(value="@cacheTime")
    protected String cacheTime;
    @XNode(value="@private")
    protected boolean isPrivate;
    @XNode(value="@grant")
    protected boolean grant = true;
    protected String pattern;
    protected Pattern compiledPattern;

    public FilterConfigDescriptor() {
    }

    public FilterConfigDescriptor(String name, String pattern, boolean grant, boolean tx, boolean sync, boolean cached, boolean isPrivate, String cacheTime) {
        this.name = name;
        this.pattern = Framework.expandVars((String)pattern);
        this.grant = grant;
        this.useSync = sync;
        this.useTx = tx;
        this.cached = cached;
        this.isPrivate = isPrivate;
        this.cacheTime = cacheTime;
    }

    public String getName() {
        if (this.name == null) {
            return this.pattern;
        }
        return this.name;
    }

    public boolean useSync() {
        return this.useSync;
    }

    public boolean useTx() {
        return this.useTx;
    }

    public boolean useTxBuffered() {
        return this.useTxBuffered;
    }

    public boolean isGrantRule() {
        return this.grant;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getCacheTime() {
        if (this.cacheTime == null || this.cacheTime.equals("")) {
            this.cacheTime = DEFAULT_CACHE_DURATION;
        }
        return this.cacheTime;
    }

    public String getPatternStr() {
        return this.pattern;
    }

    public Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.pattern);
        }
        return this.compiledPattern;
    }

    @XNode(value="pattern")
    public void setPattern(String pattern) {
        this.pattern = Framework.expandVars((String)pattern);
    }
}

