/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.AbstractClusterOperation;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;

class LockOperation
extends AbstractClusterOperation {
    private NodeId nodeId;
    private boolean deep;
    private String owner;
    private boolean isLock;

    protected LockOperation(ClusterNode clusterNode, String workspace, Record record, NodeId nodeId, boolean deep, String owner) {
        super(clusterNode, workspace, record);
        this.nodeId = nodeId;
        this.deep = deep;
        this.owner = owner;
        this.isLock = true;
    }

    protected LockOperation(ClusterNode clusterNode, String workspace, Record record, NodeId nodeId) {
        super(clusterNode, workspace, record);
        this.nodeId = nodeId;
        this.isLock = false;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public boolean isDeep() {
        return this.deep;
    }

    public String getOwner() {
        return this.owner;
    }

    public void write() throws JournalException {
        this.record.writeChar('L');
        this.record.writeNodeId(this.nodeId);
        this.record.writeBoolean(this.isLock);
        if (this.isLock) {
            this.record.writeBoolean(this.deep);
            this.record.writeString(this.owner);
        }
    }
}

