/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TempFileInputStream
extends InputStream {
    private final File file;
    private final InputStream in;
    private boolean closed;

    public static long writeToFileAndClose(InputStream in, File file) throws IOException {
        int n;
        FileOutputStream out = new FileOutputStream(file);
        byte[] b = new byte[4096];
        while ((n = in.read(b)) >= 0) {
            ((OutputStream)out).write(b, 0, n);
        }
        ((OutputStream)out).close();
        in.close();
        return file.length();
    }

    public TempFileInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.in = new BufferedInputStream(new FileInputStream(file));
    }

    private int closeIfEOF(int read) throws IOException {
        if (read < 0) {
            this.close();
        }
        return read;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.in.close();
            this.file.delete();
            this.closed = true;
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.closeIfEOF(this.in.read(b, off, len));
    }

    public int read(byte[] b) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.closeIfEOF(this.in.read(b));
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.closeIfEOF(this.in.read());
    }
}

