/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectionFactory {
    public static Connection getConnection(String driver, String url, String user, String password) throws RepositoryException, SQLException {
        if (driver != null && driver.length() > 0) {
            try {
                Class<?> d = Class.forName(driver);
                if (Context.class.isAssignableFrom(d)) {
                    Context context = (Context)d.newInstance();
                    DataSource ds = (DataSource)context.lookup(url);
                    if (user == null && password == null) {
                        return ds.getConnection();
                    }
                    return ds.getConnection(user, password);
                }
                try {
                    d.newInstance();
                }
                catch (Throwable e) {}
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryException("Could not load class " + driver, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new RepositoryException("Could not instantiate context " + driver, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new RepositoryException("Could not instantiate context " + driver, (Throwable)e);
            }
            catch (NamingException e) {
                throw new RepositoryException("Naming exception using " + driver + " url: " + url, (Throwable)e);
            }
        }
        return DriverManager.getConnection(url, user, password);
    }
}

