/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.NodeIteratorImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocOrderNodeIteratorImpl
implements ScoreNodeIterator {
    private static final Logger log = LoggerFactory.getLogger((Class)DocOrderNodeIteratorImpl.class);
    private NodeIteratorImpl orderedNodes;
    private final List scoreNodes;
    protected final ItemManager itemMgr;

    DocOrderNodeIteratorImpl(ItemManager itemMgr, List scoreNodes) {
        this.itemMgr = itemMgr;
        this.scoreNodes = scoreNodes;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        return this.orderedNodes.nextNodeImpl();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        this.orderedNodes.skip(skipNum);
    }

    public long getSize() {
        if (this.orderedNodes != null) {
            return this.orderedNodes.getSize();
        }
        return this.scoreNodes.size();
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.orderedNodes.getPosition();
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.orderedNodes.hasNext();
    }

    public float getScore() {
        this.initOrderedIterator();
        return this.orderedNodes.getScore();
    }

    private void initOrderedIterator() {
        if (this.orderedNodes != null) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = this.scoreNodes.toArray(new ScoreNode[this.scoreNodes.size()]);
        final ArrayList invalidIDs = new ArrayList(2);
        do {
            if (invalidIDs.size() > 0) {
                ArrayList<ScoreNode> tmp = new ArrayList<ScoreNode>();
                for (int i = 0; i < nodes.length; ++i) {
                    if (invalidIDs.contains(nodes[i].getNodeId())) continue;
                    tmp.add(nodes[i]);
                }
                nodes = tmp.toArray(new ScoreNode[tmp.size()]);
                invalidIDs.clear();
            }
            try {
                Arrays.sort(nodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ScoreNode n1 = (ScoreNode)o1;
                        ScoreNode n2 = (ScoreNode)o2;
                        try {
                            int commonDepth;
                            NodeImpl node2;
                            NodeImpl node1;
                            try {
                                node1 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItem(n1.getNodeId());
                            }
                            catch (RepositoryException e) {
                                log.warn("Node " + n1.getNodeId() + " does not exist anymore: " + (Object)((Object)e));
                                invalidIDs.add(n1.getNodeId());
                                throw new SortFailedException();
                            }
                            try {
                                node2 = (NodeImpl)DocOrderNodeIteratorImpl.this.itemMgr.getItem(n2.getNodeId());
                            }
                            catch (RepositoryException e) {
                                log.warn("Node " + n2.getNodeId() + " does not exist anymore: " + (Object)((Object)e));
                                invalidIDs.add(n2.getNodeId());
                                throw new SortFailedException();
                            }
                            Path.Element[] path1 = node1.getPrimaryPath().getElements();
                            Path.Element[] path2 = node2.getPrimaryPath().getElements();
                            for (commonDepth = 0; path1.length > commonDepth && path2.length > commonDepth && path1[commonDepth].equals(path2[commonDepth]); ++commonDepth) {
                            }
                            if (path1.length - 1 == --commonDepth) {
                                return -1;
                            }
                            if (path2.length - 1 == commonDepth) {
                                return 1;
                            }
                            NodeImpl commonNode = (NodeImpl)node1.getAncestor(commonDepth);
                            node1 = (NodeImpl)node1.getAncestor(commonDepth + 1);
                            node2 = (NodeImpl)node2.getAncestor(commonDepth + 1);
                            NodeIterator it = commonNode.getNodes();
                            while (it.hasNext()) {
                                Node child = it.nextNode();
                                if (child.isSame((Item)node1)) {
                                    return -1;
                                }
                                if (!child.isSame((Item)node2)) continue;
                                return 1;
                            }
                            log.error("Internal error: unable to determine document order of nodes:");
                            log.error("\tNode1: " + node1.getPath());
                            log.error("\tNode2: " + node2.getPath());
                        }
                        catch (RepositoryException e) {
                            log.error("Exception while sorting nodes in document order: " + e.toString(), (Throwable)e);
                        }
                        invalidIDs.add(n1.getNodeId());
                        invalidIDs.add(n2.getNodeId());
                        throw new SortFailedException();
                    }
                });
            }
            catch (SortFailedException e) {
                // empty catch block
            }
        } while (invalidIDs.size() > 0);
        if (log.isDebugEnabled()) {
            log.debug("" + nodes.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms");
        }
        this.orderedNodes = new NodeIteratorImpl(this.itemMgr, nodes);
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }
}

