/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.xml.AbstractSAXEventGenerator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocViewSAXEventGenerator
extends AbstractSAXEventGenerator {
    private static Logger log = LoggerFactory.getLogger((Class)DocViewSAXEventGenerator.class);
    public static final String CDATA_TYPE = "CDATA";
    private final List props = new ArrayList();

    public DocViewSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        super(node, noRecurse, skipBinary, contentHandler);
    }

    private Name getQName(String rawName) throws RepositoryException {
        try {
            return this.resolver.getQName(rawName);
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected void entering(Node node, int level) throws RepositoryException, SAXException {
    }

    protected void enteringProperties(Node node, int level) throws RepositoryException, SAXException {
        this.props.clear();
    }

    protected void leavingProperties(Node node, int level) throws RepositoryException, SAXException {
        String name = node.getName();
        if (name.equals(this.jcrXMLText)) {
            Iterator iter = this.props.iterator();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                String propName = prop.getName();
                if (!propName.equals(this.jcrXMLCharacters)) continue;
                char[] chars = prop.getValue().getString().toCharArray();
                this.contentHandler.characters(chars, 0, chars.length);
            }
        } else {
            String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode((String)name);
            AttributesImpl attrs = new AttributesImpl();
            this.addNamespacePrefixes(level, attrs);
            Iterator iter = this.props.iterator();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                String propName = prop.getName();
                if (prop.getDefinition().isMultiple()) continue;
                String attrName = ISO9075.encode((String)propName);
                Name qName = this.getQName(attrName);
                if (prop.getType() == 2 && this.skipBinary) {
                    attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, "");
                    continue;
                }
                StringBuffer attrValue = new StringBuffer();
                attrValue.append(ValueHelper.serialize((Value)prop.getValue(), (boolean)false));
                attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, attrValue.toString());
            }
            Name qName = this.getQName(elemName);
            this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, attrs);
        }
    }

    protected void leaving(Node node, int level) throws RepositoryException, SAXException {
        String name = node.getName();
        if (name.equals(this.jcrXMLText)) {
            return;
        }
        String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode((String)name);
        Name qName = this.getQName(elemName);
        this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
    }

    protected void entering(Property prop, int level) throws RepositoryException, SAXException {
        this.props.add(prop);
    }

    protected void leaving(Property prop, int level) throws RepositoryException, SAXException {
    }
}

