/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.service;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.BuiltinModes;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.LayoutException;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowComparator;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebLayoutManagerImpl
extends DefaultComponent
implements WebLayoutManager {
    public static final ComponentName NAME = new ComponentName(WebLayoutManagerImpl.class.getName());
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    private static final long serialVersionUID = -4778456059717447736L;
    private static final Log log = LogFactory.getLog(WebLayoutManagerImpl.class);
    protected final Map<String, WidgetType> widgetTypeRegistry;
    protected final Map<String, WidgetTypeDefinition> widgetTypeDefinitionRegistry = new HashMap<String, WidgetTypeDefinition>();
    protected final Map<String, LayoutDefinition> layoutRegistry;
    protected final Map<String, WidgetDefinition> widgetRegistry;

    public WebLayoutManagerImpl() {
        this.widgetTypeRegistry = new HashMap<String, WidgetType>();
        this.layoutRegistry = new HashMap<String, LayoutDefinition>();
        this.widgetRegistry = new HashMap<String, WidgetDefinition>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.registerWidgetType(contribution);
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.registerLayout(contribution);
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.registerWidget(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            this.unregisterWidgetType(contribution);
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            this.unregisterLayout(contribution);
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            this.unregisterWidget(contribution);
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(WebLayoutManager.class)) {
            return (T)this;
        }
        return null;
    }

    protected void registerWidgetType(Object contribution) {
        Class<?> widgetTypeClass;
        WidgetTypeDefinition desc = (WidgetTypeDefinition)contribution;
        String name = desc.getName();
        String className = desc.getHandlerClassName();
        if (className == null) {
            log.error((Object)("Handler class missing for widget type " + name));
            return;
        }
        try {
            widgetTypeClass = WebLayoutManagerImpl.class.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            log.error((Object)"Caught error when instantiating widget type handler", (Throwable)e);
            return;
        }
        if (this.widgetTypeRegistry.containsKey(name) || this.widgetTypeDefinitionRegistry.containsKey(name)) {
            log.warn((Object)String.format("Overriding definition for widget type %s", name));
            this.widgetTypeRegistry.remove(name);
            this.widgetTypeDefinitionRegistry.remove(name);
        }
        WidgetTypeImpl widgetType = new WidgetTypeImpl(name, widgetTypeClass, desc.getProperties());
        this.widgetTypeRegistry.put(name, (WidgetType)widgetType);
        this.widgetTypeDefinitionRegistry.put(name, desc);
        log.info((Object)("Registered widget type: " + name));
    }

    protected void unregisterWidgetType(Object contribution) {
        WidgetTypeDescriptor desc = (WidgetTypeDescriptor)contribution;
        String name = desc.getName();
        if (this.widgetTypeRegistry.containsKey(name)) {
            this.widgetTypeRegistry.remove(name);
            log.debug((Object)("Unregistered widget type: " + name));
        }
    }

    protected void registerLayout(Object contribution) {
        LayoutDefinition layoutDef = (LayoutDefinition)contribution;
        String name = layoutDef.getName();
        if (this.layoutRegistry.containsKey(name)) {
            this.layoutRegistry.remove(name);
        }
        this.layoutRegistry.put(name, layoutDef);
        log.info((Object)("Registered layout: " + name));
    }

    protected void unregisterLayout(Object contribution) {
        LayoutDefinition layoutDef = (LayoutDefinition)contribution;
        String name = layoutDef.getName();
        if (this.layoutRegistry.containsKey(name)) {
            this.layoutRegistry.remove(name);
            log.debug((Object)("Unregistered layout: " + name));
        }
    }

    protected void registerWidget(Object contribution) {
        WidgetDefinition widgetDef = (WidgetDefinition)contribution;
        String name = widgetDef.getName();
        if (this.widgetRegistry.containsKey(name)) {
            this.widgetRegistry.remove(name);
        }
        this.widgetRegistry.put(name, widgetDef);
        log.info((Object)("Registered widget: " + name));
    }

    protected void unregisterWidget(Object contribution) {
        WidgetDefinition widgetDef = (WidgetDefinition)contribution;
        String name = widgetDef.getName();
        if (this.widgetRegistry.containsKey(name)) {
            this.widgetRegistry.remove(name);
            log.debug((Object)("Unregistered widget: " + name));
        }
    }

    public WidgetType getWidgetType(String typeName) {
        return this.widgetTypeRegistry.get(typeName);
    }

    public WidgetTypeDefinition getWidgetTypeDefinition(String typeName) {
        return this.widgetTypeDefinitionRegistry.get(typeName);
    }

    public List<WidgetTypeDefinition> getWidgetTypeDefinitions() {
        ArrayList<WidgetTypeDefinition> res = new ArrayList<WidgetTypeDefinition>();
        Collection<WidgetTypeDefinition> defs = this.widgetTypeDefinitionRegistry.values();
        if (defs != null) {
            res.addAll(defs);
        }
        return res;
    }

    public LayoutDefinition getLayoutDefinition(String layoutName) {
        return this.layoutRegistry.get(layoutName);
    }

    public WidgetDefinition getWidgetDefinition(String widgetName) {
        return this.widgetRegistry.get(widgetName);
    }

    @Override
    public WidgetTypeHandler getWidgetTypeHandler(String typeName) throws WidgetException {
        WidgetTypeHandler handler;
        WidgetType type = this.getWidgetType(typeName);
        if (type == null) {
            return null;
        }
        try {
            handler = (WidgetTypeHandler)type.getWidgetTypeClass().newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Caught error when instanciating widget type handler", (Throwable)e);
            return null;
        }
        handler.setProperties(type.getProperties());
        return handler;
    }

    protected static Object evaluateExpression(FaceletContext context, String expression) {
        if (expression == null) {
            return null;
        }
        if (context == null) {
            return expression;
        }
        Object value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)expression);
        if (value != null && value instanceof String) {
            value = ComponentTagUtils.resolveElExpression((FaceletContext)context, (String)((String)value));
        }
        return value;
    }

    protected static Boolean getBooleanValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        log.error((Object)("Could not get boolean value for " + value));
        return Boolean.FALSE;
    }

    protected static String getStringValue(FaceletContext context, String expression) {
        Object value = WebLayoutManagerImpl.evaluateExpression(context, expression);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        log.error((Object)("Could not get string value for " + value));
        return null;
    }

    protected static String getModeFromLayoutMode(FaceletContext context, WidgetDefinition wDef, String layoutMode) {
        String wMode = WebLayoutManagerImpl.getStringValue(context, wDef.getMode(layoutMode));
        if (wMode == null) {
            wMode = BuiltinModes.getWidgetModeFromLayoutMode((String)layoutMode);
        }
        return wMode;
    }

    protected Widget getWidget(FaceletContext context, LayoutDefinition lDef, WidgetDefinition wDef, String layoutMode, String valueName, int level) {
        VariableMapper orig = null;
        if (context != null) {
            orig = context.getVariableMapper();
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            context.setVariableMapper((VariableMapper)vm);
            ExpressionFactory eFactory = context.getExpressionFactory();
            ValueExpression modeVe = eFactory.createValueExpression((Object)layoutMode, String.class);
            vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        }
        String wMode = WebLayoutManagerImpl.getModeFromLayoutMode(context, wDef, layoutMode);
        if (context != null) {
            context.setVariableMapper(orig);
        }
        if ("hidden".equals(wMode)) {
            return null;
        }
        ArrayList<Widget> subWidgets = new ArrayList<Widget>();
        for (WidgetDefinition swDef : wDef.getSubWidgetDefinitions()) {
            Widget subWidget = this.getWidget(context, lDef, swDef, wMode, valueName, level + 1);
            if (subWidget == null) continue;
            subWidgets.add(subWidget);
        }
        boolean required = WebLayoutManagerImpl.getBooleanValue(context, wDef.getRequired(layoutMode, wMode));
        WidgetImpl widget = new WidgetImpl(lDef.getName(), wDef.getName(), wMode, wDef.getType(), valueName, wDef.getFieldDefinitions(), wDef.getLabel(layoutMode), wDef.getHelpLabel(layoutMode), wDef.isTranslated(), wDef.getProperties(layoutMode, wMode), required, subWidgets.toArray(new Widget[0]), level, wDef.getSelectOptions());
        return widget;
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName) throws LayoutException {
        return this.getLayout(ctx, layoutName, mode, valueName, null, false);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, String layoutName, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        LayoutDefinition layoutDef = this.getLayoutDefinition(layoutName);
        if (layoutDef == null) {
            log.debug((Object)String.format("Layout %s not found", layoutName));
            return null;
        }
        return this.getLayout(ctx, layoutDef, mode, valueName, selectedRows, selectAllRowsByDefault);
    }

    @Override
    public Layout getLayout(FaceletContext ctx, LayoutDefinition layoutDef, String mode, String valueName, List<String> selectedRows, boolean selectAllRowsByDefault) {
        if (layoutDef == null) {
            log.debug((Object)"Layout definition is null");
            return null;
        }
        String layoutName = layoutDef.getName();
        if (ctx == null) {
            log.warn((Object)"Layout creation computed in a null facelet context: expressions found in the layout definition will not be evaluated");
        }
        LayoutRowDefinition[] rowsDef = layoutDef.getRows();
        ArrayList<LayoutRowImpl> rows = new ArrayList<LayoutRowImpl>();
        HashSet<String> foundRowNames = new HashSet<String>();
        int rowIndex = -1;
        for (LayoutRowDefinition rowDef : rowsDef) {
            ++rowIndex;
            String rowName = rowDef.getName();
            if (rowName == null) {
                rowName = "layout_row_" + rowIndex;
                if (selectedRows != null) {
                    log.debug((Object)String.format("Generating default name '%s' in layout '%s' for row or column at index %s", rowName, layoutName, rowIndex));
                }
            }
            boolean emptyRow = true;
            if (selectedRows != null && !selectedRows.contains(rowName) && !rowDef.isAlwaysSelected() || selectedRows == null && !selectAllRowsByDefault && !rowDef.isSelectedByDefault() && !rowDef.isAlwaysSelected()) continue;
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            for (String widgetName : rowDef.getWidgets()) {
                if (widgetName == null || widgetName.length() == 0) {
                    widgets.add(null);
                    continue;
                }
                WidgetDefinition wDef = layoutDef.getWidgetDefinition(widgetName);
                if (wDef == null) {
                    wDef = this.getWidgetDefinition(widgetName);
                }
                if (wDef == null) {
                    log.error((Object)String.format("Widget %s not found in layout %s", widgetName, layoutName));
                    widgets.add(null);
                    continue;
                }
                Widget widget = this.getWidget(ctx, layoutDef, wDef, mode, valueName, 0);
                if (widget != null) {
                    emptyRow = false;
                }
                widgets.add(widget);
            }
            if (!emptyRow) {
                rows.add(new LayoutRowImpl(rowName, rowDef.isSelectedByDefault(), rowDef.isAlwaysSelected(), widgets, rowDef.getProperties(mode)));
            }
            foundRowNames.add(rowName);
        }
        if (selectedRows != null) {
            Collections.sort(rows, new LayoutRowComparator(selectedRows));
            for (String selectedRow : selectedRows) {
                if (foundRowNames.contains(selectedRow)) continue;
                log.debug((Object)String.format("Selected row or column named '%s' was not found in layout '%s'", selectedRow, layoutName));
            }
        }
        int columns = layoutDef.getColumns();
        LayoutImpl layout = new LayoutImpl(layoutDef.getName(), mode, layoutDef.getTemplate(mode), rows, columns, layoutDef.getProperties(mode));
        return layout;
    }

    @Override
    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig config, Widget widget) {
        String widgetTypeName = widget.getType();
        WidgetTypeHandler handler = this.getWidgetTypeHandler(widgetTypeName);
        if (handler != null) {
            FaceletHandler[] subHandlers = null;
            Widget[] subWidgets = widget.getSubWidgets();
            if (subWidgets != null) {
                ArrayList<FaceletHandler> subHandlersList = new ArrayList<FaceletHandler>();
                for (Widget subWidget : subWidgets) {
                    subHandlersList.add(this.getFaceletHandler(ctx, config, subWidget));
                }
                subHandlers = subHandlersList.toArray(new FaceletHandler[0]);
            }
            FaceletHandler fHandler = handler.getFaceletHandler(ctx, config, widget, subHandlers);
            return fHandler;
        }
        log.error((Object)("No widget handler found for type " + widgetTypeName));
        return null;
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, Map<String, Serializable> properties, Widget[] subWidgets) {
        return this.createWidget(ctx, type, mode, valueName, null, null, null, null, properties, subWidgets);
    }

    @Override
    public Widget createWidget(FaceletContext ctx, String type, String mode, String valueName, List<FieldDefinition> fieldDefinitions, String label, String helpLabel, Boolean translated, Map<String, Serializable> properties, Widget[] subWidgets) {
        Serializable requiredProp = properties.get("required");
        boolean required = false;
        if (requiredProp != null) {
            if (requiredProp instanceof Boolean) {
                required = (Boolean)requiredProp;
            } else if (requiredProp instanceof String) {
                required = WebLayoutManagerImpl.getBooleanValue(ctx, (String)((Object)requiredProp));
            } else {
                log.error((Object)String.format("Invalid property \"%s\" on widget: %s", "required", requiredProp));
            }
        }
        WidgetImpl widget = new WidgetImpl("layout", "widget", mode, type, valueName, fieldDefinitions.toArray(new FieldDefinition[0]), label, helpLabel, Boolean.TRUE.equals(translated), properties, required, subWidgets, 0);
        return widget;
    }
}

