/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.cache.SeamCacheHelper;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.clipboard.DocumentListZipExporter;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="clipboardActions")
@Scope(value=ScopeType.SESSION)
public class ClipboardActionsBean
extends InputController
implements ClipboardActions,
Serializable {
    private static final long serialVersionUID = -2407222456116573225L;
    private static final Log log = LogFactory.getLog(ClipboardActionsBean.class);
    private static final String PASTE_OUTCOME = "after_paste";
    @Deprecated
    public static final String DELETED_LIFECYCLE_STATE = "deleted";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    @RequestParameter
    protected String workListDocId;
    private String currentSelectedList;
    private String previouslySelectedList;
    private transient List<String> availableLists;
    private transient List<DocumentsListDescriptor> descriptorsForAvailableLists;
    private Boolean canEditSelectedDocs;
    private transient Map<String, List<Action>> actionCache;
    @RequestParameter
    String listIdToSelect;

    @Override
    public void releaseClipboardableDocuments() {
    }

    @Override
    public boolean isInitialized() {
        return this.documentManager != null;
    }

    @Override
    public void putSelectionInWorkList(Boolean forceAppend) {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            this.putSelectionInWorkList(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"), forceAppend);
            this.autoSelectCurrentList("DEFAULT");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    public void putSelectionInWorkList() {
        this.putSelectionInWorkList(false);
    }

    @Override
    public void putSelectionInDefaultWorkList() {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            List<DocumentModel> docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Object[] params = new Object[]{docsList.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
            this.documentsListsManager.addToWorkingList("DEFAULT", docsList);
            this.autoSelectCurrentList("DEFAULT");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    @WebRemote
    public void putInClipboard(String docId) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        this.documentsListsManager.addToWorkingList("CLIPBOARD", doc);
        Object[] params = new Object[]{1};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
        this.autoSelectCurrentList("CLIPBOARD");
    }

    @Override
    public void putSelectionInClipboard() {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            List<DocumentModel> docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Object[] params = new Object[]{docsList.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
            this.documentsListsManager.addToWorkingList("CLIPBOARD", docsList);
            this.autoSelectCurrentList("CLIPBOARD");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    public void putSelectionInWorkList(List<DocumentModel> docsList) {
        this.putSelectionInWorkList(docsList, false);
    }

    @Override
    public void putSelectionInWorkList(List<DocumentModel> docsList, Boolean forceAppend) {
        this.canEditSelectedDocs = null;
        if (null != docsList) {
            Object[] params = new Object[]{docsList.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_added_to_worklist_docs"), params);
            this.documentsListsManager.addToWorkingList(this.getCurrentSelectedListName(), docsList, forceAppend);
            log.debug((Object)"Elements copied to clipboard...");
        } else {
            log.debug((Object)"No copiedDocs to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    @Deprecated
    public void copySelection(List<DocumentModel> copiedDocs) {
        if (null != copiedDocs) {
            Object[] params = new Object[]{copiedDocs.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
            this.documentsListsManager.resetWorkingList("CLIPBOARD");
            this.documentsListsManager.addToWorkingList("CLIPBOARD", copiedDocs);
            this.documentsListsManager.addToWorkingList(copiedDocs);
            log.debug((Object)"Elements copied to clipboard...");
        } else {
            log.debug((Object)"No copiedDocs to process copy on...");
        }
        log.debug((Object)"Copy processed...");
    }

    @Override
    public String removeWorkListItem(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument(ref);
        this.documentsListsManager.removeFromWorkingList(this.getCurrentSelectedListName(), doc);
        return null;
    }

    @Override
    public String clearWorkingList() {
        this.documentsListsManager.resetWorkingList(this.getCurrentSelectedListName());
        return null;
    }

    @Override
    public String pasteDocumentList(String listName) throws ClientException {
        return this.pasteDocumentList(this.documentsListsManager.getWorkingList(listName));
    }

    @Override
    public String pasteDocumentListInside(String listName, String docId) throws ClientException {
        return this.pasteDocumentListInside(this.documentsListsManager.getWorkingList(listName), docId);
    }

    @Override
    public String pasteDocumentList(List<DocumentModel> docPaste) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (null != docPaste) {
            List<DocumentModel> newDocs = this.recreateDocumentsWithNewParent(this.getParent(currentDocument), docPaste);
            Object[] params = new Object[]{newDocs.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_pasted_docs"), params);
            EventManager.raiseEventsOnDocumentSelected(currentDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            log.debug((Object)"Elements pasted and created into the backend...");
        } else {
            log.debug((Object)"No docPaste to process paste on...");
        }
        return this.computeOutcome(PASTE_OUTCOME);
    }

    @Override
    public String pasteDocumentListInside(List<DocumentModel> docPaste, String docId) throws ClientException {
        DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        if (null != docPaste) {
            List<DocumentModel> newDocs = this.recreateDocumentsWithNewParent(targetDoc, docPaste);
            Object[] params = new Object[]{newDocs.size()};
            this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_pasted_docs"), params);
            EventManager.raiseEventsOnDocumentSelected(targetDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{targetDoc});
            log.debug((Object)"Elements pasted and created into the backend...");
        } else {
            log.debug((Object)"No docPaste to process paste on...");
        }
        return null;
    }

    public List<DocumentModel> moveDocumentsToNewParent(DocumentModel destFolder, List<DocumentModel> docs) throws ClientException {
        DocumentRef destFolderRef = destFolder.getRef();
        boolean destinationIsDeleted = DELETED_LIFECYCLE_STATE.equals(destFolder.getCurrentLifeCycleState());
        ArrayList<DocumentModel> newDocs = new ArrayList<DocumentModel>();
        StringBuilder sb = new StringBuilder();
        for (DocumentModel docModel : docs) {
            DocumentModel newDoc;
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = this.typeManager.isAllowedSubType(sourceType, destFolder.getType(), this.navigationContext.getCurrentDocument());
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder) continue;
            if (destinationIsDeleted) {
                if (this.checkDeletedState(docModel)) {
                    newDoc = this.documentManager.move(docModel.getRef(), destFolderRef, null);
                    this.setDeleteState(newDoc);
                    newDocs.add(newDoc);
                    continue;
                }
                this.addWarnMessage(sb, docModel);
                continue;
            }
            newDoc = this.documentManager.move(docModel.getRef(), destFolderRef, null);
            newDocs.add(newDoc);
        }
        this.documentManager.save();
        if (sb.length() > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, sb.toString(), null);
        }
        return newDocs;
    }

    public String moveDocumentList(String listName, String docId) throws ClientException {
        List<DocumentModel> docs = this.documentsListsManager.getWorkingList(listName);
        DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        HashSet<DocumentRef> parentRefs = new HashSet<DocumentRef>();
        for (DocumentModel doc : docs) {
            parentRefs.add(doc.getParentRef());
        }
        List<DocumentModel> newDocs = this.moveDocumentsToNewParent(targetDoc, docs);
        this.documentsListsManager.resetWorkingList(listName);
        Object[] params = new Object[]{newDocs.size()};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_moved_docs"), params);
        EventManager.raiseEventsOnDocumentSelected(targetDoc);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{targetDoc});
        for (DocumentRef docRef : parentRefs) {
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(docRef)});
        }
        log.debug((Object)"Elements moved and created into the backend...");
        return null;
    }

    public String moveDocumentList(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.moveDocumentList(listName, currentDocument.getId());
    }

    @Override
    public String moveWorkingList() {
        try {
            this.moveDocumentList(this.getCurrentSelectedListName());
        }
        catch (ClientException e) {
            log.info((Object)("moveWorkingList failed" + e.getMessage()), (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.WARN, this.resourcesAccessor.getMessages().get("invalid_operation"), null);
        }
        return null;
    }

    @Override
    public String pasteWorkingList() {
        try {
            this.pasteDocumentList(this.getCurrentSelectedList());
        }
        catch (ClientException e) {
            log.info((Object)("pasteWorkingList failed" + e.getMessage()), (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.WARN, this.resourcesAccessor.getMessages().get("invalid_operation"), null);
        }
        return null;
    }

    @Override
    public String pasteClipboard() {
        try {
            this.pasteDocumentList("CLIPBOARD");
            this.returnToPreviouslySelectedList();
        }
        catch (ClientException e) {
            log.info((Object)("pasteClipboard failed" + e.getMessage()), (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.WARN, this.resourcesAccessor.getMessages().get("invalid_operation"), null);
        }
        return null;
    }

    @Override
    @WebRemote
    public String pasteClipboardInside(String docId) throws ClientException {
        this.pasteDocumentListInside("CLIPBOARD", docId);
        return null;
    }

    @Override
    @WebRemote
    public String moveClipboardInside(String docId) throws ClientException {
        this.moveDocumentList("CLIPBOARD", docId);
        return null;
    }

    protected List<DocumentModel> recreateDocumentsWithNewParent(DocumentModel parent, List<DocumentModel> documents) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        if (null == parent || null == documents) {
            log.error((Object)"Null params received, returning...");
            return newDocuments;
        }
        LinkedList<DocumentModel> documentsToPast = new LinkedList<DocumentModel>();
        for (DocumentModel doc : documents) {
            if (!this.typeManager.isAllowedSubType(doc.getType(), parent.getType(), this.navigationContext.getCurrentDocument())) continue;
            documentsToPast.add(doc);
        }
        boolean isPublishSpace = this.isPublishSpace(parent);
        boolean destinationIsDeleted = DELETED_LIFECYCLE_STATE.equals(parent.getCurrentLifeCycleState());
        ArrayList<DocumentRef> docRefs = new ArrayList<DocumentRef>();
        ArrayList<DocumentRef> proxyRefs = new ArrayList<DocumentRef>();
        StringBuilder sb = new StringBuilder();
        for (DocumentModel doc : documentsToPast) {
            if (destinationIsDeleted && !this.checkDeletedState(doc)) {
                this.addWarnMessage(sb, doc);
                continue;
            }
            if (doc.isProxy() && !isPublishSpace) {
                proxyRefs.add(doc.getRef());
                continue;
            }
            docRefs.add(doc.getRef());
        }
        if (!proxyRefs.isEmpty()) {
            newDocuments.addAll(this.documentManager.copyProxyAsDocument(proxyRefs, parent.getRef()));
        }
        if (!docRefs.isEmpty()) {
            newDocuments.addAll(this.documentManager.copy(docRefs, parent.getRef()));
        }
        if (destinationIsDeleted) {
            for (DocumentModel d : newDocuments) {
                this.setDeleteState(d);
            }
        }
        this.documentManager.save();
        if (sb.length() > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, sb.toString(), null);
        }
        return newDocuments;
    }

    protected boolean checkDeletedState(DocumentModel doc) throws ClientException {
        if (DELETED_LIFECYCLE_STATE.equals(doc.getCurrentLifeCycleState())) {
            return true;
        }
        return doc.getAllowedStateTransitions().contains("delete");
    }

    protected void setDeleteState(DocumentModel doc) throws ClientException {
        if (doc.getAllowedStateTransitions().contains("delete")) {
            doc.followTransition("delete");
        }
    }

    protected void addWarnMessage(StringBuilder sb, DocumentModel doc) throws ClientException {
        if (sb.length() == 0) {
            sb.append(this.resourcesAccessor.getMessages().get("document_no_deleted_state"));
            sb.append("'").append(doc.getTitle()).append("'");
        } else {
            sb.append(", '").append(doc.getTitle()).append("'");
        }
    }

    protected boolean isPublishSpace(DocumentModel container) throws ClientException {
        SchemaManager schemaManager;
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        HashSet publishSpaces = null;
        if (schemaManager != null) {
            publishSpaces = schemaManager.getDocumentTypeNamesForFacet("PublishSpace");
        }
        if (publishSpaces == null || publishSpaces.isEmpty()) {
            publishSpaces = new HashSet();
        }
        return publishSpaces.contains(container.getType());
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam component: clipboardActions");
    }

    protected DocumentModel getParent(DocumentModel currentDocument) throws ClientException {
        if (currentDocument.isFolder()) {
            return currentDocument;
        }
        DocumentModelList parents = this.navigationContext.getCurrentPath();
        for (int i = parents.size() - 1; i >= 0; --i) {
            DocumentModel parent = (DocumentModel)parents.get(i);
            if (!parent.isFolder()) continue;
            return parent;
        }
        return null;
    }

    @Override
    @Factory(value="isCurrentWorkListEmpty", scope=ScopeType.EVENT)
    public boolean factoryForIsCurrentWorkListEmpty() {
        return this.isWorkListEmpty();
    }

    @Override
    public boolean isWorkListEmpty() {
        return this.documentsListsManager.isWorkingListEmpty(this.getCurrentSelectedListName());
    }

    @Override
    public String exportWorklistAsZip() throws ClientException {
        return this.exportWorklistAsZip(this.documentsListsManager.getWorkingList(this.getCurrentSelectedListName()));
    }

    @Override
    public String exportAllBlobsFromWorkingListAsZip() throws ClientException {
        return this.exportWorklistAsZip();
    }

    @Override
    public String exportMainBlobFromWorkingListAsZip() throws ClientException {
        return this.exportWorklistAsZip();
    }

    @Override
    public String exportWorklistAsZip(List<DocumentModel> documents) throws ClientException {
        return this.exportWorklistAsZip(documents, true);
    }

    public String exportWorklistAsZip(DocumentModel document) throws ClientException {
        return this.exportWorklistAsZip(Arrays.asList(document), true);
    }

    @Override
    public boolean getCanCopy() {
        if (this.navigationContext.getCurrentDocument() == null) {
            return false;
        }
        return !this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION");
    }

    @Override
    public boolean getCanPaste(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (this.documentsListsManager.isWorkingListEmpty(listName) || currentDocument == null) {
            return false;
        }
        DocumentModel pasteTarget = this.getParent(this.navigationContext.getCurrentDocument());
        if (!this.documentManager.hasPermission(pasteTarget.getRef(), "AddChildren")) {
            return false;
        }
        List<String> pasteTypesName = this.documentsListsManager.getWorkingListTypes(listName);
        for (String pasteTypeName : pasteTypesName) {
            if (!this.typeManager.isAllowedSubType(pasteTypeName, pasteTarget.getType(), this.navigationContext.getCurrentDocument())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanPasteInside(String listName, DocumentModel document) throws ClientException {
        if (this.documentsListsManager.isWorkingListEmpty(listName) || document == null) {
            return false;
        }
        if (!this.documentManager.hasPermission(document.getRef(), "AddChildren")) {
            return false;
        }
        List<String> pasteTypesName = this.documentsListsManager.getWorkingListTypes(listName);
        for (String pasteTypeName : pasteTypesName) {
            if (!this.typeManager.isAllowedSubType(pasteTypeName, document.getType(), this.navigationContext.getCurrentDocument())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanMoveInside(String listName, DocumentModel document) throws ClientException {
        if (this.documentsListsManager.isWorkingListEmpty(listName) || document == null) {
            return false;
        }
        DocumentRef destFolderRef = document.getRef();
        DocumentModel destFolder = document;
        if (!this.documentManager.hasPermission(destFolderRef, "AddChildren")) {
            return false;
        }
        for (DocumentModel docModel : this.documentsListsManager.getWorkingList(listName)) {
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = this.typeManager.isAllowedSubType(sourceType, destFolder.getType(), this.navigationContext.getCurrentDocument());
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder) continue;
            return true;
        }
        return false;
    }

    public boolean getCanMove(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanMoveInside(listName, currentDocument);
    }

    @Override
    public boolean getCanPasteWorkList() throws ClientException {
        return this.getCanPaste(this.getCurrentSelectedListName());
    }

    @Override
    public boolean getCanMoveWorkingList() throws ClientException {
        return this.getCanMove(this.getCurrentSelectedListName());
    }

    @Override
    public boolean getCanPasteFromClipboard() throws ClientException {
        return this.getCanPaste("CLIPBOARD");
    }

    @Override
    public boolean getCanPasteFromClipboardInside(DocumentModel document) throws ClientException {
        return this.getCanPasteInside("CLIPBOARD", document);
    }

    @Override
    public boolean getCanMoveFromClipboardInside(DocumentModel document) throws ClientException {
        return this.getCanMoveInside("CLIPBOARD", document);
    }

    @Override
    public void setCurrentSelectedList(String listId) {
        if (listId != null && !listId.equals(this.currentSelectedList)) {
            this.currentSelectedList = listId;
            this.canEditSelectedDocs = null;
        }
    }

    @Override
    public void selectList() {
        if (this.listIdToSelect != null) {
            this.setCurrentSelectedList(this.listIdToSelect);
        }
    }

    @Override
    public List<DocumentModel> getCurrentSelectedList() {
        return this.documentsListsManager.getWorkingList(this.getCurrentSelectedListName());
    }

    @Override
    public String getCurrentSelectedListName() {
        if (this.currentSelectedList == null && !this.getAvailableLists().isEmpty()) {
            this.setCurrentSelectedList(this.availableLists.get(0));
        }
        return this.currentSelectedList;
    }

    @Override
    public String getCurrentSelectedListTitle() {
        DocumentsListDescriptor desc;
        String title = null;
        String listName = this.getCurrentSelectedListName();
        if (listName != null && (desc = this.documentsListsManager.getWorkingListDescriptor(listName)) != null) {
            title = desc.getTitle();
        }
        return title;
    }

    @Override
    public List<String> getAvailableLists() {
        if (this.availableLists == null) {
            this.availableLists = this.documentsListsManager.getWorkingListNamesForCategory("CLIPBOARD");
        }
        return this.availableLists;
    }

    @Override
    public List<DocumentsListDescriptor> getDescriptorsForAvailableLists() {
        if (this.descriptorsForAvailableLists == null) {
            List<String> availableLists = this.getAvailableLists();
            this.descriptorsForAvailableLists = new ArrayList<DocumentsListDescriptor>();
            for (String lName : availableLists) {
                this.descriptorsForAvailableLists.add(this.documentsListsManager.getWorkingListDescriptor(lName));
            }
        }
        return this.descriptorsForAvailableLists;
    }

    @Override
    public List<Action> getActionsForCurrentList() {
        String lstName = this.getCurrentSelectedListName();
        if (this.isWorkListEmpty()) {
            if (this.actionCache == null) {
                this.actionCache = new HashMap<String, List<Action>>();
            }
            if (!this.actionCache.containsKey(lstName)) {
                this.actionCache.put(lstName, this.webActions.getActionsList(lstName + "_LIST"));
            }
            return this.actionCache.get(lstName);
        }
        return this.webActions.getActionsList(lstName + "_LIST");
    }

    @Override
    public List<Action> getActionsForSelection() {
        return this.webActions.getUnfiltredActionsList("CURRENT_SELECTION_LIST");
    }

    private void autoSelectCurrentList(String listName) {
        this.previouslySelectedList = this.getCurrentSelectedListName();
        this.setCurrentSelectedList(listName);
    }

    private void returnToPreviouslySelectedList() {
        this.setCurrentSelectedList(this.previouslySelectedList);
    }

    @Override
    public boolean getCanEditSelectedDocs() throws ClientException {
        if (this.canEditSelectedDocs == null) {
            if (this.getCurrentSelectedList().isEmpty()) {
                this.canEditSelectedDocs = false;
            } else {
                List<DocumentModel> selectedDocs = this.getCurrentSelectedList();
                this.canEditSelectedDocs = this.checkWritePerm(selectedDocs);
            }
        }
        return this.canEditSelectedDocs;
    }

    @Override
    @Deprecated
    public boolean getCanEditListDocs(String listName) throws ClientException {
        List<DocumentModel> docs = this.documentsListsManager.getWorkingList(listName);
        boolean canEdit = docs.isEmpty() ? false : this.checkWritePerm(docs);
        return canEdit;
    }

    private boolean checkWritePerm(List<DocumentModel> selectedDocs) throws ClientException {
        for (DocumentModel documentModel : selectedDocs) {
            boolean canWrite = this.documentManager.hasPermission(documentModel.getRef(), "WriteProperties");
            if (canWrite) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCacheEnabled() {
        if (!SeamCacheHelper.canUseSeamCache()) {
            return false;
        }
        return this.isWorkListEmpty();
    }

    @Override
    public String getCacheKey() {
        return this.getCurrentSelectedListName() + "::" + this.localeSelector.getLocaleString();
    }

    @Override
    public boolean isCacheEnabledForSelection() {
        if (!SeamCacheHelper.canUseSeamCache()) {
            return false;
        }
        return this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION");
    }

    @Override
    public String exportWorklistAsZip(List<DocumentModel> documents, boolean exportAllBlobs) throws ClientException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            DocumentListZipExporter zipExporter = new DocumentListZipExporter();
            File tmpFile = zipExporter.exportWorklistAsZip(documents, this.documentManager, exportAllBlobs);
            if (tmpFile == null) {
                this.setFacesMessage("label.clipboard.emptyDocuments");
                return null;
            }
            if (tmpFile.length() > Functions.getBigFileSizeLimit()) {
                HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
                String zipDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
                zipDownloadURL = zipDownloadURL + "nxbigzipfile/";
                zipDownloadURL = zipDownloadURL + tmpFile.getName();
                try {
                    context.getExternalContext().redirect(zipDownloadURL);
                }
                catch (IOException e) {
                    log.error((Object)"Error while redirecting for big file downloader", (Throwable)e);
                }
            } else {
                ComponentUtils.downloadFile((FacesContext)context, (String)"clipboard.zip", (File)tmpFile);
            }
            return "";
        }
        catch (IOException io) {
            throw ClientException.wrap((Throwable)io);
        }
    }
}

