/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.impl;

import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.impl.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpiFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public final class CmisBindingsHelper {
    public static final String REPOSITORY_INFO_CACHE = "org.apache.chemistry.opencmis.bindings.repositoryInfoCache";
    public static final String TYPE_DEFINTION_CACHE = "org.apache.chemistry.opencmis.bindings.typeDefintionCache";
    public static final String SPI_OBJECT = "org.apache.chemistry.opencmis.bindings.spi.object";
    public static final String AUTHENTICATION_PROVIDER_OBJECT = "org.apache.chemistry.opencmis.bindings.auth.object";

    private CmisBindingsHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmisSpi getSPI(Session session) {
        CmisSpi spi = (CmisSpi)session.get(SPI_OBJECT);
        if (spi != null) {
            return spi;
        }
        session.writeLock();
        try {
            spi = (CmisSpi)session.get(SPI_OBJECT);
            if (spi != null) {
                CmisSpi cmisSpi = spi;
                return cmisSpi;
            }
            try {
                String spiFactoryName = (String)session.get("org.apache.chemistry.opencmis.binding.spi.classname");
                Class<?> spiFactoryClass = Class.forName(spiFactoryName);
                Object spiFactory = spiFactoryClass.newInstance();
                if (!(spiFactory instanceof CmisSpiFactory)) {
                    throw new CmisRuntimeException("Not a CMISSPIFactory class!");
                }
                spi = ((CmisSpiFactory)spiFactory).getSpiInstance(session);
                if (spi == null) {
                    throw new CmisRuntimeException("SPI factory returned null!");
                }
            }
            catch (CmisBaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CmisRuntimeException("SPI cannot be initialized: " + e.getMessage(), (Throwable)e);
            }
            session.put(SPI_OBJECT, spi, true);
        }
        finally {
            session.writeUnlock();
        }
        return spi;
    }

    public static AbstractAuthenticationProvider getAuthenticationProvider(Session session) {
        return (AbstractAuthenticationProvider)session.get(AUTHENTICATION_PROVIDER_OBJECT);
    }

    public static RepositoryInfoCache getRepositoryInfoCache(Session session) {
        return (RepositoryInfoCache)session.get(REPOSITORY_INFO_CACHE);
    }

    public static TypeDefinitionCache getTypeDefinitionCache(Session session) {
        return (TypeDefinitionCache)session.get(TYPE_DEFINTION_CACHE);
    }
}

