/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        HashMap<String, List<String>> result = null;
        if (!this.isTrue("org.apache.chemistry.opencmis.binding.auth.http.basic")) {
            return null;
        }
        result = new HashMap<String, List<String>>();
        String user = this.getUser();
        String password = this.getPassword();
        if (user != null) {
            if (password == null) {
                password = "";
            }
            try {
                String authHeader = "Basic " + new String(Base64.encodeBase64((byte[])(user + ":" + password).getBytes("ISO-8859-1")), "ISO-8859-1");
                result.put("Authorization", Collections.singletonList(authHeader));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        String proxyUser = this.getProxyUser();
        String proxyPassword = this.getProxyPassword();
        if (proxyUser != null) {
            if (proxyPassword == null) {
                proxyPassword = "";
            }
            try {
                String authHeader = "Basic " + new String(Base64.encodeBase64((byte[])(proxyUser + ":" + proxyPassword).getBytes("ISO-8859-1")), "ISO-8859-1");
                result.put("Proxy-Authorization", Collections.singletonList(authHeader));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public Element getSOAPHeaders(Object portObject) {
        String user = this.getUser();
        String password = this.getPassword();
        if (!this.isTrue("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken")) {
            return null;
        }
        if (user == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        long created = System.currentTimeMillis();
        long expires = created + 86400000L;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element wsseSecurityElement = document.createElementNS(WSSE_NAMESPACE, "Security");
            Element wsuTimestampElement = document.createElementNS(WSU_NAMESPACE, "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS(WSU_NAMESPACE, "Created");
            tsCreatedElement.setTextContent(sdf.format(created));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS(WSU_NAMESPACE, "Expires");
            tsExpiresElement.setTextContent(sdf.format(expires));
            wsuTimestampElement.appendChild(tsExpiresElement);
            Element usernameTokenElement = document.createElementNS(WSSE_NAMESPACE, "UsernameToken");
            wsseSecurityElement.appendChild(usernameTokenElement);
            Element usernameElement = document.createElementNS(WSSE_NAMESPACE, "Username");
            usernameElement.setTextContent(user);
            usernameTokenElement.appendChild(usernameElement);
            Element passwordElement = document.createElementNS(WSSE_NAMESPACE, "Password");
            passwordElement.setTextContent(password);
            passwordElement.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            usernameTokenElement.appendChild(passwordElement);
            Element createdElement = document.createElementNS(WSU_NAMESPACE, "Created");
            createdElement.setTextContent(sdf.format(created));
            usernameTokenElement.appendChild(createdElement);
            return wsseSecurityElement;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isTrue(String parameterName) {
        Object value = this.getSession().get(parameterName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

