/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmActorsListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmSecurityPolicy;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;

public interface JbpmService {
    public static final String ACL_PREFIX = "WORKFLOW_ACL_";

    public JbpmConfiguration getConfiguration();

    public Serializable executeJbpmOperation(JbpmOperation var1) throws NuxeoJbpmException;

    public List<TaskInstance> getCurrentTaskInstances(NuxeoPrincipal var1, JbpmListFilter var2) throws NuxeoJbpmException;

    public List<TaskInstance> getCurrentTaskInstances(List<String> var1, JbpmActorsListFilter var2) throws NuxeoJbpmException;

    public List<TaskInstance> getTaskInstances(Long var1, NuxeoPrincipal var2, JbpmListFilter var3) throws NuxeoJbpmException;

    public void endTask(Long var1, String var2, Map<String, Serializable> var3, Map<String, Serializable> var4, Map<String, Serializable> var5, NuxeoPrincipal var6) throws NuxeoJbpmException;

    public List<String> getAvailableTransitions(Long var1, NuxeoPrincipal var2) throws NuxeoJbpmException;

    public void saveTaskInstances(List<TaskInstance> var1) throws NuxeoJbpmException;

    public void deleteProcessInstance(NuxeoPrincipal var1, Long var2) throws NuxeoJbpmException;

    public List<ProcessInstance> getCurrentProcessInstances(NuxeoPrincipal var1, JbpmListFilter var2) throws NuxeoJbpmException;

    public List<ProcessInstance> getCurrentProcessInstances(List<String> var1, JbpmActorsListFilter var2) throws NuxeoJbpmException;

    public ProcessInstance getProcessInstance(Long var1) throws NuxeoJbpmException;

    public ProcessInstance createProcessInstance(NuxeoPrincipal var1, String var2, DocumentModel var3, Map<String, Serializable> var4, Map<String, Serializable> var5) throws NuxeoJbpmException;

    public List<ProcessDefinition> getProcessDefinitions(NuxeoPrincipal var1, DocumentModel var2, JbpmListFilter var3) throws NuxeoJbpmException;

    public List<ProcessDefinition> getProcessDefinitionsByType(String var1) throws NuxeoJbpmException;

    public ProcessDefinition getProcessDefinitionByName(String var1) throws NuxeoJbpmException;

    public void endProcessInstance(Long var1) throws NuxeoJbpmException;

    public ProcessInstance persistProcessInstance(ProcessInstance var1) throws NuxeoJbpmException;

    public DocumentModel getDocumentModel(TaskInstance var1, NuxeoPrincipal var2) throws NuxeoJbpmException;

    public DocumentModel getDocumentModel(ProcessInstance var1, NuxeoPrincipal var2) throws NuxeoJbpmException;

    public List<TaskInstance> getTaskInstances(DocumentModel var1, NuxeoPrincipal var2, JbpmListFilter var3) throws NuxeoJbpmException;

    public List<TaskInstance> getTaskInstances(DocumentModel var1, List<String> var2, JbpmActorsListFilter var3) throws NuxeoJbpmException;

    public List<ProcessInstance> getProcessInstances(DocumentModel var1, NuxeoPrincipal var2, JbpmListFilter var3) throws NuxeoJbpmException;

    public Map<String, List<String>> getTypeFilterConfiguration();

    public Boolean getPermission(ProcessInstance var1, JbpmSecurityPolicy.Action var2, DocumentModel var3, NuxeoPrincipal var4) throws NuxeoJbpmException;

    public void notifyEventListeners(String var1, String var2, String[] var3, CoreSession var4, NuxeoPrincipal var5, DocumentModel var6) throws ClientException;

    public static enum HibernateQueries {
        NuxeoHibernateQueries_getProcessInstancesForDoc,
        NuxeoHibernateQueries_getTaskInstancesForDoc_byTaskMgmt,
        NuxeoHibernateQueries_getTaskInstancesForDoc_byTask,
        NuxeoHibernateQueries_getProcessInstancesForInitiator;

    }

    public static enum TaskVariableName {
        directive,
        validated,
        right;

    }

    public static enum VariableName {
        documentId,
        documentRepositoryName,
        endLifecycleTransition,
        initiator,
        participants,
        participant,
        document,
        principal;

    }
}

