/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class SymmetricScenarioServer {
    static int bindPort = 6666;
    static String connectHost = "localhost";
    static int connectPort = 5555;

    public void runSymmetricScenario() {
        try {
            ServerSocket ss = new ServerSocket(bindPort);
            Socket syncSocket = ss.accept();
            ss.close();
            InputStream is_sync = syncSocket.getInputStream();
            OutputStream os_sync = syncSocket.getOutputStream();
            MasterServerSocket mss = new MasterServerSocket(bindPort + 1);
            os_sync.write(3);
            mss.setSoTimeout(5000);
            int port = mss.acceptServerSocketConnection();
            mss.close();
            is_sync.read();
            VirtualServerSocket vss = new VirtualServerSocket(port);
            InetSocketAddress address = new InetSocketAddress(connectHost, connectPort);
            vss.setSoTimeout(5000);
            vss.connect(address);
            os_sync.write(7);
            Socket virtualSocket1 = vss.accept();
            InputStream is1 = virtualSocket1.getInputStream();
            OutputStream os1 = virtualSocket1.getOutputStream();
            VirtualSocket virtualSocket2 = new VirtualSocket(connectHost, connectPort);
            InputStream is2 = ((Socket)virtualSocket2).getInputStream();
            OutputStream os2 = ((Socket)virtualSocket2).getOutputStream();
            os1.write(is1.read());
            os2.write(is2.read());
            virtualSocket1.close();
            ((Socket)virtualSocket2).close();
            syncSocket.close();
            vss.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 3) {
            bindPort = Integer.parseInt(args[0]);
            connectHost = args[1];
            connectPort = Integer.parseInt(args[2]);
        }
        new SymmetricScenarioServer().runSymmetricScenario();
    }
}

