/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.jbpm;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.api.PublishingException;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreProxyFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.jbpm.ChangePermissionUnrestricted;
import org.nuxeo.ecm.platform.publisher.jbpm.DeleteDocumentUnrestricted;
import org.nuxeo.ecm.platform.publisher.jbpm.LookupState;
import org.nuxeo.ecm.platform.publisher.jbpm.LookupStateByACL;
import org.nuxeo.ecm.platform.publisher.jbpm.LookupStateByTask;
import org.nuxeo.ecm.platform.publisher.jbpm.RemoveACLUnrestricted;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CoreProxyWithWorkflowFactory
extends CoreProxyFactory
implements PublishedDocumentFactory {
    public static final String TASK_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String ACL_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String JBPM_ACL_NAME = "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory";
    public static final String PUBLISH_TASK_TYPE = "publish_moderate";
    public static final String LOOKUP_STATE_PARAM_KEY = "lookupState";
    public static final String LOOKUP_STATE_PARAM_BYACL = "byACL";
    public static final String LOOKUP_STATE_PARAM_BYTASK = "byTask";
    protected LookupState lookupState = new LookupStateByACL();

    public void init(CoreSession coreSession, ValidatorsRule validatorsRule, Map<String, String> parameters) throws ClientException {
        super.init(coreSession, validatorsRule, parameters);
        String lookupState = parameters.get(LOOKUP_STATE_PARAM_KEY);
        if (lookupState != null) {
            if (LOOKUP_STATE_PARAM_BYACL.equals(lookupState)) {
                this.setLookupByACL();
            } else if (LOOKUP_STATE_PARAM_BYTASK.equals(lookupState)) {
                this.setLookupByTask();
            }
        }
    }

    public void setLookupByTask() {
        this.lookupState = new LookupStateByTask();
    }

    public void setLookupByACL() {
        this.lookupState = new LookupStateByACL();
    }

    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        DocumentModel targetDocModel;
        if (targetNode instanceof CoreFolderPublicationNode) {
            CoreFolderPublicationNode coreNode = (CoreFolderPublicationNode)targetNode;
            targetDocModel = coreNode.getTargetDocumentModel();
        } else {
            targetDocModel = this.coreSession.getDocument((DocumentRef)new PathRef(targetNode.getPath()));
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        DocumentPublisherUnrestricted runner = new DocumentPublisherUnrestricted(this.coreSession, doc.getRef(), targetDocModel.getRef(), principal, null);
        runner.runUnrestricted();
        return runner.getPublishedDocument();
    }

    protected boolean isPublishedDocWaitingForPublication(DocumentModel doc, CoreSession session) throws ClientException {
        return !this.lookupState.isPublished(doc, session);
    }

    protected boolean isValidator(DocumentModel document, NuxeoPrincipal principal) throws PublishingException {
        try {
            String[] validators;
            for (String s : validators = this.getValidatorsFor(document)) {
                if (!principal.getName().equals(s) && !principal.isMemberOf(s)) continue;
                return true;
            }
        }
        catch (PublishingValidatorException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    protected void restrictPermission(DocumentModel newProxy, NuxeoPrincipal principal, CoreSession coreSession, ACL acl) throws PublishingValidatorException, PublishingException {
        ChangePermissionUnrestricted permissionChanger = new ChangePermissionUnrestricted(coreSession, newProxy, this.getValidatorsFor(newProxy), principal, "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory", acl);
        try {
            permissionChanger.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void createTask(DocumentModel document, CoreSession session, NuxeoPrincipal principal) throws PublishingValidatorException, NuxeoJbpmException, PublishingException {
        TaskInstance ti = new TaskInstance();
        String[] actorIds = this.getValidatorsFor(document);
        ArrayList<String> prefixedActorIds = new ArrayList<String>();
        for (String s : actorIds) {
            String prefix;
            if (s.contains(":")) {
                prefixedActorIds.add(s);
                continue;
            }
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            try {
                prefix = userManager.getPrincipal(s) == null ? "group:" : "user:";
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            prefixedActorIds.add(prefix + s);
        }
        ti.setPooledActors(prefixedActorIds.toArray(new String[prefixedActorIds.size()]));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(JbpmService.VariableName.documentId.name(), document.getId());
        variables.put(JbpmService.VariableName.documentRepositoryName.name(), document.getRepositoryName());
        variables.put(JbpmService.VariableName.initiator.name(), principal.getName());
        ti.setVariables(variables);
        ti.setName("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
        ti.setCreate(new Date());
        this.getJbpmService().saveTaskInstances(Collections.singletonList(ti));
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, document);
        ctx.setProperty("recipients", (Serializable)prefixedActorIds.toArray(new String[prefixedActorIds.size()]));
        try {
            this.getEventProducer().fireEvent(ctx.newEvent("workflowTaskAssigned"));
            this.getEventProducer().fireEvent(ctx.newEvent("workflowTaskStart"));
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected JbpmService getJbpmService() {
        return (JbpmService)Framework.getLocalService(JbpmService.class);
    }

    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        try {
            ProxyCleaner proxyCleaner = new ProxyCleaner(this.coreSession, proxy);
            proxyCleaner.runUnrestricted();
        }
        catch (ClientException e1) {
            throw new PublishingException(e1.getMessage(), (Throwable)e1);
        }
        try {
            this.removeACL(proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationApproved);
            this.notifyEvent(PublishingEvent.documentPublicationApproved, proxy, this.coreSession);
            this.notifyEvent(PublishingEvent.documentPublished, proxy, this.coreSession);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
        ((SimpleCorePublishedDocument)publishedDocument).setPending(false);
    }

    protected void removeACL(DocumentModel document, CoreSession coreSession) throws PublishingException {
        try {
            RemoveACLUnrestricted remover = new RemoveACLUnrestricted(coreSession, document, "org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
            remover.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void endTask(DocumentModel document, NuxeoPrincipal currentUser, CoreSession session, String comment, PublishingEvent event) throws PublishingException {
        try {
            JbpmService jbpmService = this.getJbpmService();
            List tis = jbpmService.getTaskInstances(document, currentUser, null);
            String initiator = null;
            for (TaskInstance ti : tis) {
                if (!ti.getName().equals("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory")) continue;
                initiator = (String)ti.getVariable(JbpmService.VariableName.initiator.name());
                ti.end();
                jbpmService.saveTaskInstances(Collections.singletonList(ti));
                break;
            }
            GetsProxySourceDocumentsUnrestricted runner = new GetsProxySourceDocumentsUnrestricted(session, document);
            runner.runUnrestricted();
            HashMap<String, String[]> properties = new HashMap<String, String[]>();
            if (initiator != null) {
                properties.put("recipients", new String[]{initiator});
            }
            this.notifyEvent(event.name(), properties, comment, null, runner.liveDocument, session);
        }
        catch (NuxeoJbpmException e) {
            throw new PublishingException((Throwable)e);
        }
        catch (ClientException ce) {
            throw new PublishingException((Throwable)ce);
        }
    }

    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal principal = (NuxeoPrincipal)this.coreSession.getPrincipal();
        try {
            this.notifyEvent(PublishingEvent.documentPublicationRejected, proxy, this.coreSession);
            this.removeProxy(proxy, this.coreSession);
            this.endTask(proxy, principal, this.coreSession, comment, PublishingEvent.documentPublicationRejected);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    protected void removeProxy(DocumentModel doc, CoreSession coreSession) throws PublishingException {
        try {
            DeleteDocumentUnrestricted deleter = new DeleteDocumentUnrestricted(coreSession, doc);
            deleter.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    public PublishedDocument wrapDocumentModel(DocumentModel doc) throws ClientException {
        final SimpleCorePublishedDocument publishedDocument = (SimpleCorePublishedDocument)super.wrapDocumentModel(doc);
        new UnrestrictedSessionRunner(this.coreSession){

            public void run() throws ClientException {
                if (!CoreProxyWithWorkflowFactory.this.isPublished((PublishedDocument)publishedDocument, this.session)) {
                    publishedDocument.setPending(true);
                }
            }
        }.runUnrestricted();
        return publishedDocument;
    }

    protected boolean isPublished(PublishedDocument publishedDocument, CoreSession session) throws PublishingException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        try {
            return this.lookupState.isPublished(proxy, session);
        }
        catch (ClientException e) {
            throw new PublishingException((Throwable)e);
        }
    }

    public boolean canManagePublishing(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return proxy.isProxy() && this.hasValidationTask(proxy, currentUser);
    }

    protected boolean hasValidationTask(DocumentModel proxy, NuxeoPrincipal currentUser) throws ClientException {
        assert (currentUser != null);
        try {
            List tis = this.getJbpmService().getTaskInstances(proxy, currentUser, null);
            for (TaskInstance ti : tis) {
                if (!ti.getName().equals("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory")) continue;
                return true;
            }
        }
        catch (NuxeoJbpmException e) {
            throw new PublishingException((Throwable)e);
        }
        return false;
    }

    public boolean hasValidationTask(PublishedDocument publishedDocument) throws ClientException {
        DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.coreSession.getPrincipal();
        return this.hasValidationTask(proxy, currentUser);
    }

    protected class DocumentPublisherUnrestricted
    extends UnrestrictedSessionRunner {
        protected PublishedDocument result;
        protected DocumentRef docRef;
        protected DocumentRef targetRef;
        protected NuxeoPrincipal principal;
        protected String comment;

        public DocumentPublisherUnrestricted(CoreSession session, DocumentRef docRef, DocumentRef targetRef, NuxeoPrincipal principal, String comment) {
            super(session);
            this.comment = "";
            this.docRef = docRef;
            this.targetRef = targetRef;
            this.principal = principal;
            this.comment = comment;
        }

        public PublishedDocument getPublishedDocument() {
            return this.result;
        }

        public void run() throws ClientException {
            DocumentModelList list = this.session.getProxies(this.docRef, this.targetRef);
            if (list.isEmpty()) {
                DocumentModel proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                this.session.save();
                if (!CoreProxyWithWorkflowFactory.this.isValidator(proxy, this.principal)) {
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentWaitingPublication, CoreProxyWithWorkflowFactory.this.coreSession.getDocument(proxy.getRef()), CoreProxyWithWorkflowFactory.this.coreSession);
                    CoreProxyWithWorkflowFactory.this.restrictPermission(proxy, this.principal, this.session, null);
                    CoreProxyWithWorkflowFactory.this.createTask(proxy, CoreProxyWithWorkflowFactory.this.coreSession, this.principal);
                    publishedDocument.setPending(true);
                } else {
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                }
                this.result = publishedDocument;
            } else if (list.size() == 1) {
                if (CoreProxyWithWorkflowFactory.this.isPublishedDocWaitingForPublication((DocumentModel)list.get(0), this.session)) {
                    DocumentModel proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    if (!CoreProxyWithWorkflowFactory.this.isValidator(proxy, this.principal)) {
                        ACL acl = ((DocumentModel)list.get(0)).getACP().getACL("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
                        acl.add(0, (Object)new ACE(this.principal.getName(), "Read", true));
                        ACP acp = proxy.getACP();
                        acp.addACL(acl);
                        this.session.setACP(proxy.getRef(), acp, true);
                        this.session.save();
                        SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                        publishedDocument.setPending(true);
                        this.result = publishedDocument;
                    } else {
                        CoreProxyWithWorkflowFactory.this.endTask(proxy, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, "", PublishingEvent.documentPublicationApproved);
                        CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                        ACP acp = proxy.getACP();
                        acp.removeACL("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
                        this.session.setACP(proxy.getRef(), acp, true);
                        this.session.save();
                        this.result = new SimpleCorePublishedDocument(proxy);
                    }
                } else if (!CoreProxyWithWorkflowFactory.this.isValidator((DocumentModel)list.get(0), this.principal)) {
                    DocumentModel proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef), false);
                    this.session.save();
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentWaitingPublication, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    CoreProxyWithWorkflowFactory.this.restrictPermission(proxy, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, null);
                    this.session.save();
                    CoreProxyWithWorkflowFactory.this.createTask(proxy, CoreProxyWithWorkflowFactory.this.coreSession, this.principal);
                    publishedDocument.setPending(true);
                    this.result = publishedDocument;
                } else {
                    DocumentModel proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    this.session.save();
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    this.result = publishedDocument;
                }
            } else if (list.size() == 2) {
                DocumentModel waitingForPublicationDoc = null;
                this.session.save();
                for (DocumentModel dm : list) {
                    if (this.session.getACP(dm.getRef()).getACL("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory") == null) continue;
                    waitingForPublicationDoc = dm;
                }
                if (!CoreProxyWithWorkflowFactory.this.isValidator(waitingForPublicationDoc, this.principal)) {
                    ACL acl = waitingForPublicationDoc.getACP().getACL("org.nuxeo.ecm.platform.publisher.jbpm.CoreProxyWithWorkflowFactory");
                    acl.add(0, (Object)new ACE(this.principal.getName(), "Read", true));
                    ACP acp = this.session.getACP(waitingForPublicationDoc.getRef());
                    acp.addACL(acl);
                    this.session.setACP(waitingForPublicationDoc.getRef(), acp, true);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(waitingForPublicationDoc);
                    publishedDocument.setPending(true);
                    this.result = publishedDocument;
                } else {
                    CoreProxyWithWorkflowFactory.this.endTask(waitingForPublicationDoc, this.principal, CoreProxyWithWorkflowFactory.this.coreSession, this.comment, PublishingEvent.documentPublicationApproved);
                    this.session.removeDocument(waitingForPublicationDoc.getRef());
                    DocumentModel proxy = this.session.publishDocument(this.session.getDocument(this.docRef), this.session.getDocument(this.targetRef));
                    CoreProxyWithWorkflowFactory.this.notifyEvent(PublishingEvent.documentPublished, proxy, CoreProxyWithWorkflowFactory.this.coreSession);
                    SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
                    this.result = publishedDocument;
                }
            }
        }
    }

    protected class ProxyCleaner
    extends UnrestrictedSessionRunner {
        DocumentModel proxy;

        public ProxyCleaner(CoreSession session, DocumentModel proxy) {
            super(session);
            this.proxy = proxy;
        }

        public void run() throws ClientException {
            DocumentModel sourceVersion = this.session.getSourceDocument(this.proxy.getRef());
            DocumentModel dm = this.session.getSourceDocument(sourceVersion.getRef());
            DocumentModelList brothers = this.session.getProxies(dm.getRef(), this.proxy.getParentRef());
            if (brothers != null && brothers.size() > 1) {
                for (DocumentModel doc : brothers) {
                    if (doc.getId().equals(this.proxy.getId())) continue;
                    this.session.removeDocument(doc.getRef());
                }
            }
        }
    }

    private class GetsProxySourceDocumentsUnrestricted
    extends UnrestrictedSessionRunner {
        public DocumentModel liveDocument;
        private DocumentModel sourceDocument;
        private final DocumentModel document;

        public GetsProxySourceDocumentsUnrestricted(CoreSession session, DocumentModel proxy) {
            super(session);
            this.document = proxy;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument((DocumentRef)new IdRef(this.document.getSourceId()));
            this.liveDocument = this.session.getDocument((DocumentRef)new IdRef(this.sourceDocument.getSourceId()));
        }
    }
}

