/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NoRollbackOnException;
import org.nuxeo.runtime.api.J2EEContainerDescriptor;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionalCoreSessionWrapper
implements InvocationHandler,
Synchronization {
    private static final Log log = LogFactory.getLog(TransactionalCoreSessionWrapper.class);
    private static final Class<?>[] INTERFACES = new Class[]{CoreSession.class};
    private final CoreSession session;
    private final ThreadLocal<Boolean> threadBound = new ThreadLocal();

    protected TransactionalCoreSessionWrapper(CoreSession session) {
        this.session = session;
    }

    public static CoreSession wrap(CoreSession session) {
        try {
            TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            return session;
        }
        ClassLoader cl = session.getClass().getClassLoader();
        return (CoreSession)Proxy.newProxyInstance(cl, INTERFACES, (InvocationHandler)new TransactionalCoreSessionWrapper(session));
    }

    protected void checkTxActiveRequired(Method m) {
        if (this.threadBound.get() != null) {
            return;
        }
        if (J2EEContainerDescriptor.getSelected() == null) {
            return;
        }
        String name = m.getName();
        if ("getSessionId".equals(name)) {
            return;
        }
        if ("connect".equals(name)) {
            return;
        }
        if ("disconnect".equals(name)) {
            return;
        }
        if ("close".equals(name)) {
            return;
        }
        if ("destroy".equals(name)) {
            return;
        }
        log.warn((Object)"Session invoked in a container without a transaction active", new Throwable());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Boolean b = this.threadBound.get();
        if (b == null) {
            Transaction tx = null;
            try {
                tx = TransactionHelper.lookupTransactionManager().getTransaction();
                if (tx != null && tx.getStatus() != 1) {
                    tx.registerSynchronization((Synchronization)this);
                    this.session.afterBegin();
                    this.threadBound.set(Boolean.TRUE);
                }
            }
            catch (NamingException e) {
            }
            catch (Exception e) {
                log.error((Object)"Error on transaction synchronizer registration", (Throwable)e);
            }
            this.checkTxActiveRequired(method);
        }
        try {
            return method.invoke((Object)this.session, args);
        }
        catch (Throwable t) {
            Throwable tt;
            if (TransactionHelper.isTransactionActive() && this.needsRollback(method, t)) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            if (t instanceof InvocationTargetException && (tt = ((InvocationTargetException)t).getTargetException()) != null) {
                throw tt;
            }
            throw t;
        }
    }

    protected boolean needsRollback(Method method, Throwable t) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType() != NoRollbackOnException.class) continue;
            return false;
        }
        return true;
    }

    public void beforeCompletion() {
        this.session.beforeCompletion();
    }

    public void afterCompletion(int status) {
        boolean committed;
        this.threadBound.remove();
        if (status == 3) {
            committed = true;
        } else if (status == 4) {
            committed = false;
        } else {
            log.error((Object)("Unexpected status after completion: " + status));
            return;
        }
        this.session.afterCompletion(committed);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.session + ')';
    }
}

