/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.debug;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.debug.DirectoryEntry;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;

public class ModuleTracker
implements Runnable {
    private static final Log log = LogFactory.getLog(ModuleTracker.class);
    protected final ModuleImpl module;
    protected final DirectoryEntry rootEntry;

    public ModuleTracker(ModuleImpl module) {
        this.module = module;
        File root = module.getRoot();
        this.rootEntry = new DirectoryEntry(root);
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            log.error((Object)("Failed to check module changes for " + this.module.getName()), (Throwable)e);
        }
    }

    protected void doRun() throws Exception {
        if (this.rootEntry.check()) {
            this.module.getEngine().setDirty(true);
        }
    }

    public static void flushTypeCache(ModuleImpl module) {
        ModuleConfiguration[] modules;
        for (ModuleConfiguration mc : modules = module.getEngine().getModuleManager().getModules()) {
            if (!mc.isLoaded()) continue;
            ((ModuleImpl)mc.get()).flushTypeCache();
        }
    }

    public static void flushSkinCache(ModuleImpl module) {
        ModuleConfiguration[] modules;
        for (ModuleConfiguration mc : modules = module.getEngine().getModuleManager().getModules()) {
            if (!mc.isLoaded()) continue;
            ((ModuleImpl)mc.get()).flushSkinCache();
        }
    }
}

