/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.session.Component;
import org.nuxeo.ecm.webengine.session.ComponentMap;
import org.nuxeo.ecm.webengine.session.SessionException;

public final class UserSession
extends HashMap<String, Object> {
    private static final long serialVersionUID = 260562970988817064L;
    protected static final Log log = LogFactory.getLog(UserSession.class);
    protected Map<Class<?>, ComponentMap<?>> comps = new HashMap();
    protected HttpServletRequest request;

    protected UserSession(HttpServletRequest request) {
        this.request = request;
    }

    public static UserSession getCurrentSession(HttpServletRequest request) {
        String key = UserSession.class.getName();
        UserSession us = (UserSession)request.getAttribute(key);
        if (us == null) {
            us = new UserSession(request);
            request.setAttribute(key, (Object)us);
        }
        return us;
    }

    public CoreSession getCoreSession(String repoName) {
        try {
            return SessionFactory.getSession((HttpServletRequest)this.request, (String)repoName);
        }
        catch (Exception e) {
            log.error((Object)("Failed to open core session for repository: " + repoName), (Throwable)e);
            return null;
        }
    }

    public CoreSession getCoreSession() {
        try {
            return SessionFactory.getSession((HttpServletRequest)this.request);
        }
        catch (Exception e) {
            log.error((Object)"Failed to open core session for default repository", (Throwable)e);
            return null;
        }
    }

    public Principal getPrincipal() {
        return this.request.getUserPrincipal();
    }

    public static void addRequestCleanupHandler(HttpServletRequest request, RequestCleanupHandler handler) {
        RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(handler);
    }

    public synchronized <T extends Component> T findComponent(Class<T> type, String name) {
        ComponentMap<?> map = this.comps.get(type);
        if (map == null) {
            return null;
        }
        if (name == null) {
            return (T)map.getComponent();
        }
        return (T)((Component)type.cast(map.get(name)));
    }

    public synchronized <T extends Component> T getComponent(Class<T> type, String name) throws SessionException {
        Object comp;
        ComponentMap<Object> map = this.comps.get(type);
        if (map == null) {
            map = new ComponentMap();
            this.comps.put(type, map);
        } else {
            comp = name == null ? map.getComponent() : (Component)type.cast(map.get(name));
            if (comp != null) {
                return (T)comp;
            }
        }
        try {
            comp = (Component)type.newInstance();
        }
        catch (Exception e) {
            throw new SessionException("Failed to instantiate component: " + type, e);
        }
        comp.initialize(this, name);
        if (name == null) {
            map.setComponent(comp);
        } else {
            map.put(name, comp);
        }
        return (T)((Component)type.cast(comp));
    }

    public <T extends Component> T getComponent(Class<T> type) throws SessionException {
        return this.getComponent(type, null);
    }

    public <T extends Component> T getComponent(String typeName, String name) throws SessionException {
        try {
            Class<?> type = Class.forName(typeName);
            return (T)this.getComponent(type, name);
        }
        catch (ClassNotFoundException e) {
            throw new SessionException("Could not find component class: " + typeName, e);
        }
    }

    public <T extends Component> T getComponent(String id) throws SessionException {
        int p = id.lastIndexOf(35);
        if (p > -1) {
            return this.getComponent(id.substring(0, p), id.substring(p + 1));
        }
        return this.getComponent(id, null);
    }
}

