/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryFactoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryFactoryProxy;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class DirectoryServiceImpl
extends DefaultComponent
implements DirectoryService {
    protected static final String DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX = "_";
    private static final Log log = LogFactory.getLog(DirectoryServiceImpl.class);
    private Map<String, DirectoryFactory> factories;
    private Map<String, List<DirectoryFactory>> factoriesByDirectoryName;

    public void applicationStarted(ComponentContext context) throws Exception {
        if (Framework.isTestModeSet()) {
            return;
        }
        for (Directory dir : this.getDirectories()) {
            dir.getName();
        }
    }

    protected DirectoryConfiguration getDirectoryConfiguration(DocumentModel documentContext) {
        DirectoryConfiguration configuration = null;
        try {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            if (localConfigurationService == null) {
                log.info((Object)"Local configuration not deployed, will use default configuration");
                return null;
            }
            configuration = (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return configuration;
    }

    protected String getWaitingLocalDirectoryName(String directoryName, DirectoryConfiguration configuration) {
        if (directoryName == null) {
            return null;
        }
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            String suffix = configuration.getDirectorySuffix().trim();
            if (!"".equals(suffix)) {
                return directoryName + DELIMITER_BETWEEN_DIRECTORY_NAME_AND_SUFFIX + suffix;
            }
            log.warn((Object)"The local configuration detected is an empty value, we consider it as no configuration set.");
            log.debug((Object)("Directory Local Configuration is on : " + configuration.getDocumentRef()));
        }
        return directoryName;
    }

    public Directory getDirectory(String directoryName) throws DirectoryException {
        DirectoryFactory factory;
        if (directoryName == null) {
            return null;
        }
        List<DirectoryFactory> potentialFactories = this.factoriesByDirectoryName.get(directoryName);
        if (potentialFactories == null) {
            return null;
        }
        Directory dir = null;
        Iterator<DirectoryFactory> i$ = potentialFactories.iterator();
        while (i$.hasNext() && null == (dir = (factory = i$.next()).getDirectory(directoryName))) {
        }
        return dir;
    }

    public Directory getDirectory(String name, DocumentModel documentContext) throws DirectoryException {
        if (name == null) {
            return null;
        }
        String localDirectoryName = this.getWaitingLocalDirectoryName(name, this.getDirectoryConfiguration(documentContext));
        Directory directory = this.getDirectory(localDirectoryName);
        if (directory == null && !name.equals(localDirectoryName)) {
            log.debug((Object)("The local directory name " + localDirectoryName + " not found. Look for the default one : " + name));
            directory = this.getDirectory(name);
        }
        return directory;
    }

    private Directory getDirectoryOrFail(String name) throws DirectoryException {
        return this.getDirectoryOrFail(name, null);
    }

    private Directory getDirectoryOrFail(String name, DocumentModel documentContext) throws DirectoryException {
        Directory dir = this.getDirectory(name, documentContext);
        if (null == dir) {
            throw new DirectoryException(String.format("no directory registered with name '%s'", name));
        }
        return dir;
    }

    public List<Directory> getDirectories() throws DirectoryException {
        ArrayList<Directory> directoryList = new ArrayList<Directory>();
        for (DirectoryFactory factory : this.factories.values()) {
            List list = factory.getDirectories();
            directoryList.addAll(list);
        }
        return directoryList;
    }

    public void activate(ComponentContext context) throws Exception {
        this.factories = new HashMap<String, DirectoryFactory>();
        this.factoriesByDirectoryName = new HashMap<String, List<DirectoryFactory>>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        for (DirectoryFactory factory : this.factories.values()) {
            factory.shutdown();
        }
        this.factories = null;
        this.factoriesByDirectoryName = null;
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            this.factories.put(factoryName, new DirectoryFactoryProxy(factoryName));
            log.debug((Object)("registered factory: " + factoryName));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            DirectoryFactoryDescriptor factoryDescriptor = (DirectoryFactoryDescriptor)contrib;
            String factoryName = factoryDescriptor.getFactoryName();
            DirectoryFactory factoryToRemove = this.factories.get(factoryName);
            if (factoryToRemove == null) {
                log.warn((Object)("factory: " + factoryName + "was not registered"));
                return;
            }
            factoryToRemove.shutdown();
            for (List<DirectoryFactory> potentialFactories : this.factoriesByDirectoryName.values()) {
                potentialFactories.remove(factoryToRemove);
            }
            this.factories.remove(factoryName);
            log.debug((Object)("unregistered factory: " + factoryName));
        }
    }

    public void registerDirectory(String directoryName, DirectoryFactory factory) {
        List<DirectoryFactory> existingFactories = this.factoriesByDirectoryName.get(directoryName);
        if (existingFactories == null) {
            existingFactories = new ArrayList<DirectoryFactory>();
            this.factoriesByDirectoryName.put(directoryName, existingFactories);
        }
        existingFactories.remove(factory);
        existingFactories.add(0, factory);
    }

    public void unregisterDirectory(String directoryName, DirectoryFactory factory) {
        List<DirectoryFactory> existingFactories = this.factoriesByDirectoryName.get(directoryName);
        if (existingFactories != null) {
            existingFactories.remove(factory);
        }
    }

    public List<String> getDirectoryNames() throws DirectoryException {
        List<Directory> directories = this.getDirectories();
        ArrayList<String> directoryNames = new ArrayList<String>();
        for (Directory directory : directories) {
            directoryNames.add(directory.getName());
        }
        return directoryNames;
    }

    public String getDirectorySchema(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSchema();
    }

    public String getDirectoryIdField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getIdField();
    }

    public String getDirectoryPasswordField(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getPasswordField();
    }

    public Session open(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getSession();
    }

    public Session open(String directoryName, DocumentModel documentContext) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName, documentContext).getSession();
    }

    public String getParentDirectoryName(String directoryName) throws DirectoryException {
        return this.getDirectoryOrFail(directoryName).getParentDirectory();
    }
}

