/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.FieldDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectoryFactory;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MultiDirectorySession
extends BaseSession {
    private static final Log log = LogFactory.getLog(MultiDirectorySession.class);
    private final DirectoryService directoryService = MultiDirectoryFactory.getDirectoryService();
    private final SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    private final MultiDirectory directory;
    private final MultiDirectoryDescriptor descriptor;
    private final String schemaName;
    private final String schemaIdField;
    private final String schemaPasswordField;
    private List<SourceInfo> sourceInfos;

    public MultiDirectorySession(MultiDirectory directory) {
        this.directory = directory;
        this.descriptor = directory.getDescriptor();
        this.schemaName = this.descriptor.schemaName;
        this.schemaIdField = this.descriptor.idField;
        this.schemaPasswordField = this.descriptor.passwordField;
    }

    private void init() throws DirectoryException {
        if (this.sourceInfos == null) {
            this.recomputeSourceInfos();
        }
    }

    private void recomputeSourceInfos() throws DirectoryException {
        Schema schema = this.schemaManager.getSchema(this.schemaName);
        if (schema == null) {
            throw new DirectoryException(String.format("Directory '%s' has unknown schema '%s'", this.directory.getName(), this.schemaName));
        }
        HashSet<String> sourceFields = new HashSet<String>();
        for (Field f : schema.getFields()) {
            sourceFields.add(f.getName().getLocalName());
        }
        if (!sourceFields.contains(this.schemaIdField)) {
            throw new DirectoryException(String.format("Directory '%s' schema '%s' has no id field '%s'", this.directory.getName(), this.schemaName, this.schemaIdField));
        }
        ArrayList<SourceInfo> newSourceInfos = new ArrayList<SourceInfo>(2);
        for (SourceDescriptor source : this.descriptor.sources) {
            int ndirs = source.subDirectories.length;
            if (ndirs == 0) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' has no subdirectories", this.directory.getName(), source.name));
            }
            ArrayList<SubDirectoryInfo> subDirectoryInfos = new ArrayList<SubDirectoryInfo>(ndirs);
            SubDirectoryInfo authDirectoryInfo = null;
            boolean hasRequiredDir = false;
            for (SubDirectoryDescriptor subDir : source.subDirectories) {
                String dirName = subDir.name;
                String dirSchemaName = this.directoryService.getDirectorySchema(dirName);
                String dirIdField = this.directoryService.getDirectoryIdField(dirName);
                boolean dirIsAuth = this.directoryService.getDirectoryPasswordField(dirName) != null;
                HashMap<String, String> fromSource = new HashMap<String, String>();
                HashMap<String, String> toSource = new HashMap<String, String>();
                HashMap<String, Serializable> defaultEntry = new HashMap<String, Serializable>();
                boolean dirIsOptional = subDir.isOptional;
                Schema dirSchema = this.schemaManager.getSchema(dirSchemaName);
                if (dirSchema == null) {
                    throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has unknown schema '%s'", this.directory.getName(), source.name, dirName, dirSchemaName));
                }
                HashSet<String> dirSchemaFields = new HashSet<String>();
                for (Field f : dirSchema.getFields()) {
                    String fieldName = f.getName().getLocalName();
                    dirSchemaFields.add(fieldName);
                    if (sourceFields.contains(fieldName)) {
                        fromSource.put(fieldName, fieldName);
                        toSource.put(fieldName, fieldName);
                    }
                    defaultEntry.put(fieldName, (Serializable)f.getDefaultValue());
                }
                for (FieldDescriptor field : subDir.fields) {
                    String sourceFieldName = field.forField;
                    String fieldName = field.name;
                    if (!sourceFields.contains(sourceFieldName)) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has mapping for unknown field '%s'", this.directory.getName(), source.name, dirName, sourceFieldName));
                    }
                    if (!dirSchemaFields.contains(fieldName)) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' subdirectory '%s' has mapping of unknown field' '%s'", this.directory.getName(), source.name, dirName, fieldName));
                    }
                    fromSource.put(sourceFieldName, fieldName);
                    toSource.put(fieldName, sourceFieldName);
                }
                SubDirectoryInfo subDirectoryInfo = new SubDirectoryInfo(dirName, dirSchemaName, dirIdField, dirIsAuth, fromSource, toSource, defaultEntry, dirIsOptional);
                subDirectoryInfos.add(subDirectoryInfo);
                if (dirIsAuth) {
                    if (authDirectoryInfo != null) {
                        throw new DirectoryException(String.format("Directory '%s' source '%s' has two subdirectories with a password field, '%s' and '%s'", this.directory.getName(), source.name, authDirectoryInfo.dirName, dirName));
                    }
                    authDirectoryInfo = subDirectoryInfo;
                }
                if (dirIsOptional) continue;
                hasRequiredDir = true;
            }
            if (this.isAuthenticating() && authDirectoryInfo == null) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' has no subdirectory with a password field", this.directory.getName(), source.name));
            }
            if (!hasRequiredDir) {
                throw new DirectoryException(String.format("Directory '%s' source '%s' only has optional subdirectories: no directory can be used has a reference.", this.directory.getName(), source.name));
            }
            newSourceInfos.add(new SourceInfo(source, subDirectoryInfos, authDirectoryInfo));
        }
        this.sourceInfos = newSourceInfos;
    }

    public void close() throws DirectoryException {
        if (this.sourceInfos == null) {
            return;
        }
        DirectoryException exc = null;
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo subDirectoryInfo : sourceInfo.subDirectoryInfos) {
                Session session = subDirectoryInfo.session;
                subDirectoryInfo.session = null;
                if (session == null) continue;
                try {
                    session.close();
                }
                catch (DirectoryException e) {
                    if (exc == null) {
                        exc = e;
                        continue;
                    }
                    log.error((Object)("Error closing directory " + subDirectoryInfo.dirName), (Throwable)e);
                }
            }
        }
        this.directory.removeSession((Session)this);
        if (exc != null) {
            throw exc;
        }
    }

    public void commit() throws ClientException {
        if (this.sourceInfos == null) {
            return;
        }
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo subDirectoryInfo : sourceInfo.subDirectoryInfos) {
                Session session = subDirectoryInfo.session;
                if (session == null) continue;
                session.commit();
            }
        }
    }

    public void rollback() throws ClientException {
        if (this.sourceInfos == null) {
            return;
        }
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo subDirectoryInfo : sourceInfo.subDirectoryInfos) {
                Session session = subDirectoryInfo.session;
                if (session == null) continue;
                session.rollback();
            }
        }
    }

    public String getIdField() {
        return this.schemaIdField;
    }

    public String getPasswordField() {
        return this.schemaPasswordField;
    }

    public boolean isAuthenticating() {
        return this.schemaPasswordField != null;
    }

    public boolean isReadOnly() {
        return Boolean.TRUE.equals(this.descriptor.readOnly);
    }

    public boolean authenticate(String username, String password) throws ClientException {
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                String passwordField;
                String defaultPassword;
                if (!dirInfo.isAuthenticating) continue;
                if (dirInfo.getSession().authenticate(username, password)) {
                    return true;
                }
                if (!dirInfo.isOptional || dirInfo.getSession().getEntry(username) != null || (defaultPassword = (String)((Object)dirInfo.defaultEntry.get(passwordField = dirInfo.getSession().getPasswordField()))) == null || !defaultPassword.equals(password)) continue;
                return true;
            }
        }
        return false;
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        this.init();
        boolean isReadOnlyEntry = true;
        block4: for (SourceInfo sourceInfo : this.sourceInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                DocumentModel entry = dirInfo.getSession().getEntry(id, fetchReferences);
                boolean isOptional = dirInfo.isOptional;
                if (entry == null && !isOptional) continue block4;
                if (entry != null && !MultiDirectorySession.isReadOnlyEntry((DocumentModel)entry)) {
                    isReadOnlyEntry = false;
                }
                for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                    if (entry != null) {
                        try {
                            map.put(e.getValue(), entry.getProperty(dirInfo.dirSchemaName, e.getKey()));
                            continue;
                        }
                        catch (ClientException e1) {
                            throw new DirectoryException((Throwable)e1);
                        }
                    }
                    if (map.containsKey(e.getValue())) continue;
                    map.put(e.getValue(), dirInfo.defaultEntry.get(e.getKey()));
                }
            }
            if (this.isReadOnly()) {
                isReadOnlyEntry = true;
            }
            try {
                return BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, map, (boolean)isReadOnlyEntry);
            }
            catch (PropertyException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return null;
    }

    public DocumentModelList getEntries() throws ClientException {
        this.init();
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, String> seen = new HashMap<String, String>();
        HashSet<String> readOnlyEntries = new HashSet<String>();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            Map<String, Serializable> map;
            DocumentModelList entries;
            HashMap maps = new HashMap();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (SubDirectoryInfo dirInfo : sourceInfo.requiredSubDirectoryInfos) {
                entries = dirInfo.getSession().getEntries();
                for (DocumentModel entry : entries) {
                    String id = entry.getId();
                    map = (HashMap)maps.get(id);
                    if (map == null) {
                        map = new HashMap();
                        maps.put(id, map);
                        counts.put(id, 1);
                    } else {
                        counts.put(id, (Integer)counts.get(id) + 1);
                    }
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        map.put(e.getValue(), (Serializable)entry.getProperty(dirInfo.dirSchemaName, e.getKey()));
                    }
                    if (!BaseSession.isReadOnlyEntry((DocumentModel)entry)) continue;
                    readOnlyEntries.add(id);
                }
            }
            for (SubDirectoryInfo dirInfo : sourceInfo.optionalSubDirectoryInfos) {
                entries = dirInfo.getSession().getEntries();
                HashSet<String> existingIds = new HashSet<String>();
                for (DocumentModel entry : entries) {
                    String id = entry.getId();
                    Map map2 = (Map)maps.get(id);
                    if (map2 != null) {
                        existingIds.add(id);
                        for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                            map2.put(e.getValue(), entry.getProperty(dirInfo.dirSchemaName, e.getKey()));
                        }
                        continue;
                    }
                    log.warn((Object)String.format("Entry '%s' for source '%s' is present in optional directory '%s' but not in any required one. It will be skipped.", id, sourceInfo.source.name, dirInfo.dirName));
                }
                for (Map.Entry mapEntry : maps.entrySet()) {
                    if (existingIds.contains(mapEntry.getKey())) continue;
                    map = (Map)mapEntry.getValue();
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        if (map.containsKey(e.getValue())) continue;
                        map.put(e.getValue(), dirInfo.defaultEntry.get(e.getKey()));
                    }
                }
            }
            int numdirs = sourceInfo.requiredSubDirectoryInfos.size();
            ((ArrayList)results).ensureCapacity(results.size() + maps.size());
            for (Map.Entry e : maps.entrySet()) {
                DocumentModel entry;
                String id = (String)e.getKey();
                if (seen.containsKey(id)) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id, seen.get(id), sourceInfo.source.name));
                    continue;
                }
                Map map3 = (Map)e.getValue();
                if ((Integer)counts.get(id) != numdirs) {
                    log.warn((Object)String.format("Entry '%s' for source '%s' is not present in all directories. It will be skipped.", id, sourceInfo.source.name));
                    continue;
                }
                seen.put(id, sourceInfo.source.name);
                entry = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, (Map)map3, (boolean)readOnlyEntries.contains(id));
                results.add((Object)entry);
            }
        }
        return results;
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws ClientException {
        this.init();
        Object rawid = fieldMap.get(this.schemaIdField);
        if (rawid == null) {
            throw new DirectoryException(String.format("Entry is missing id field '%s'", this.schemaIdField));
        }
        String id = String.valueOf(rawid);
        for (SourceInfo sourceInfo : this.sourceInfos) {
            if (!sourceInfo.source.creation) continue;
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(dirInfo.idField, id);
                for (Map.Entry<String, String> e : dirInfo.fromSource.entrySet()) {
                    map.put(e.getValue(), fieldMap.get(e.getKey()));
                }
                dirInfo.getSession().createEntry(map);
            }
            return this.getEntry(id);
        }
        throw new DirectoryException(String.format("Directory '%s' has no source allowing creation", this.directory.getName()));
    }

    public void deleteEntry(DocumentModel docModel) throws ClientException {
        this.deleteEntry(docModel.getId());
    }

    public void deleteEntry(String id) throws ClientException {
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                dirInfo.getSession().deleteEntry(id);
            }
        }
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        log.warn((Object)"Calling deleteEntry extended on multi directory");
        try {
            this.deleteEntry(id);
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (ClientException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    private static void updateSubDirectoryEntry(SubDirectoryInfo dirInfo, Map<String, Object> fieldMap, String id, boolean canCreateIfOptional) throws ClientException {
        DocumentModel dirEntry = dirInfo.getSession().getEntry(id);
        if (dirInfo.getSession().isReadOnly() || dirEntry != null && MultiDirectorySession.isReadOnlyEntry((DocumentModel)dirEntry)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(dirInfo.idField, id);
        for (Map.Entry<String, String> e : dirInfo.fromSource.entrySet()) {
            map.put(e.getValue(), fieldMap.get(e.getKey()));
        }
        if (map.size() > 1) {
            if (canCreateIfOptional && dirInfo.isOptional && dirEntry == null) {
                dirInfo.getSession().createEntry(map);
            } else {
                DocumentModel entry = BaseSession.createEntryModel(null, (String)dirInfo.dirSchemaName, (String)id, map);
                dirInfo.getSession().updateEntry(entry);
            }
        }
    }

    public void updateEntry(DocumentModel docModel) throws ClientException {
        if (this.isReadOnly() || MultiDirectorySession.isReadOnlyEntry((DocumentModel)docModel)) {
            return;
        }
        this.init();
        String id = docModel.getId();
        Map fieldMap = docModel.getDataModel(this.schemaName).getMap();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            boolean canCreateIfOptional = false;
            for (SubDirectoryInfo dirInfo : sourceInfo.requiredSubDirectoryInfos) {
                if (!canCreateIfOptional) {
                    canCreateIfOptional = dirInfo.getSession().getEntry(id) != null;
                }
                MultiDirectorySession.updateSubDirectoryEntry(dirInfo, fieldMap, id, false);
            }
            for (SubDirectoryInfo dirInfo : sourceInfo.optionalSubDirectoryInfos) {
                MultiDirectorySession.updateSubDirectoryEntry(dirInfo, fieldMap, id, canCreateIfOptional);
            }
        }
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws ClientException {
        return this.query(filter, Collections.<String>emptySet());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.query(filter, fulltext, Collections.<String, String>emptyMap());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws ClientException {
        return this.query(filter, fulltext, orderBy, false);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws ClientException {
        this.init();
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, String> seen = new HashMap<String, String>();
        if (fulltext == null) {
            fulltext = Collections.emptySet();
        }
        HashSet<String> readOnlyEntries = new HashSet<String>();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            HashMap maps = new HashMap();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            ArrayList<SubDirectoryInfo> optionalDirsMatching = new ArrayList<SubDirectoryInfo>();
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                HashMap<String, Serializable> dirFilter = new HashMap<String, Serializable>();
                for (Map.Entry<String, Serializable> entry : filter.entrySet()) {
                    String string = dirInfo.fromSource.get(entry.getKey());
                    if (string == null) continue;
                    dirFilter.put(string, entry.getValue());
                }
                if (dirInfo.isOptional) {
                    boolean matches = true;
                    for (Map.Entry entry : dirFilter.entrySet()) {
                        Serializable defaultValue = dirInfo.defaultEntry.get(entry.getKey());
                        Object filterValue = entry.getValue();
                        if (defaultValue == null && filterValue != null) {
                            matches = false;
                            continue;
                        }
                        if (defaultValue == null || defaultValue.equals(filterValue)) continue;
                        matches = false;
                    }
                    if (matches) {
                        optionalDirsMatching.add(dirInfo);
                    }
                }
                HashSet<String> dirFulltext = new HashSet<String>();
                for (String string : fulltext) {
                    String fieldName = dirInfo.fromSource.get(string);
                    if (fieldName == null) continue;
                    dirFulltext.add(fieldName);
                }
                DocumentModelList documentModelList = dirInfo.getSession().query(dirFilter, dirFulltext, null, fetchReferences);
                for (DocumentModel entry : documentModelList) {
                    String id = entry.getId();
                    HashMap<String, Object> map = (HashMap<String, Object>)maps.get(id);
                    if (map == null) {
                        map = new HashMap<String, Object>();
                        maps.put(id, map);
                        counts.put(id, 1);
                    } else {
                        counts.put(id, (Integer)counts.get(id) + 1);
                    }
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        map.put(e.getValue(), entry.getProperty(dirInfo.dirSchemaName, e.getKey()));
                    }
                    if (!BaseSession.isReadOnlyEntry((DocumentModel)entry)) continue;
                    readOnlyEntries.add(id);
                }
            }
            for (SubDirectoryInfo dirInfo : optionalDirsMatching) {
                HashSet existingIds = new HashSet(dirInfo.getSession().getProjection(Collections.emptyMap(), dirInfo.idField));
                for (Map.Entry<String, Serializable> entry : maps.entrySet()) {
                    String string = entry.getKey();
                    if (existingIds.contains(string)) continue;
                    counts.put(string, (Integer)counts.get(string) + 1);
                    Map map = (Map)((Object)entry.getValue());
                    for (Map.Entry<String, String> e : dirInfo.toSource.entrySet()) {
                        String value = e.getValue();
                        if (map.containsKey(value)) continue;
                        map.put(value, dirInfo.defaultEntry.get(e.getKey()));
                    }
                }
            }
            int numdirs = sourceInfo.subDirectoryInfos.size();
            Iterator it = maps.keySet().iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                if ((Integer)counts.get(id) == numdirs) continue;
                it.remove();
            }
            ((ArrayList)results).ensureCapacity(results.size() + maps.size());
            for (Map.Entry e : maps.entrySet()) {
                String id = (String)e.getKey();
                if (seen.containsKey(id)) {
                    log.warn((Object)String.format("Entry '%s' is present in source '%s' but also in source '%s'. The second one will be ignored.", id, seen.get(id), sourceInfo.source.name));
                    continue;
                }
                Map map = (Map)e.getValue();
                seen.put(id, sourceInfo.source.name);
                DocumentModel documentModel = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, (Map)map, (boolean)readOnlyEntries.contains(id));
                results.add((Object)documentModel);
            }
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.directory.orderEntries((List)results, orderBy);
        }
        return results;
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws ClientException {
        return this.getProjection(filter, Collections.<String>emptySet(), columnName);
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws ClientException {
        DocumentModelList entries = this.query(filter, fulltext);
        ArrayList<String> results = new ArrayList<String>(entries.size());
        for (DocumentModel entry : entries) {
            Object value = entry.getProperty(this.schemaName, columnName);
            if (value == null) {
                results.add(null);
                continue;
            }
            results.add(value.toString());
        }
        return results;
    }

    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        Map fieldMap = entry.getProperties(this.schemaName);
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) throws ClientException {
        this.init();
        for (SourceInfo sourceInfo : this.sourceInfos) {
            for (SubDirectoryInfo dirInfo : sourceInfo.subDirectoryInfos) {
                Session session = dirInfo.getSession();
                if (!session.hasEntry(id)) continue;
                return true;
            }
        }
        return false;
    }

    protected static class SourceInfo {
        final SourceDescriptor source;
        final List<SubDirectoryInfo> subDirectoryInfos;
        final List<SubDirectoryInfo> requiredSubDirectoryInfos;
        final List<SubDirectoryInfo> optionalSubDirectoryInfos;
        final SubDirectoryInfo authDirectoryInfo;

        SourceInfo(SourceDescriptor source, List<SubDirectoryInfo> subDirectoryInfos, SubDirectoryInfo authDirectoryInfo) {
            this.source = source;
            this.subDirectoryInfos = subDirectoryInfos;
            this.requiredSubDirectoryInfos = new ArrayList<SubDirectoryInfo>();
            this.optionalSubDirectoryInfos = new ArrayList<SubDirectoryInfo>();
            for (SubDirectoryInfo subDirInfo : subDirectoryInfos) {
                if (subDirInfo.isOptional) {
                    this.optionalSubDirectoryInfos.add(subDirInfo);
                    continue;
                }
                this.requiredSubDirectoryInfos.add(subDirInfo);
            }
            this.authDirectoryInfo = authDirectoryInfo;
        }

        public String toString() {
            return String.format("{source=%s infos=%s}", this.source.name, this.subDirectoryInfos);
        }
    }

    protected class SubDirectoryInfo {
        final String dirName;
        final String dirSchemaName;
        final String idField;
        final boolean isAuthenticating;
        final Map<String, String> fromSource;
        final Map<String, String> toSource;
        final Map<String, Serializable> defaultEntry;
        final boolean isOptional;
        Session session;

        SubDirectoryInfo(String dirName, String dirSchemaName, String idField, boolean isAuthenticating, Map<String, String> fromSource, Map<String, String> toSource, Map<String, Serializable> defaultEntry, boolean isOptional) {
            this.dirName = dirName;
            this.dirSchemaName = dirSchemaName;
            this.idField = idField;
            this.isAuthenticating = isAuthenticating;
            this.fromSource = fromSource;
            this.toSource = toSource;
            this.defaultEntry = defaultEntry;
            this.isOptional = isOptional;
        }

        Session getSession() throws DirectoryException {
            if (this.session == null) {
                this.session = MultiDirectorySession.this.directoryService.open(this.dirName);
            }
            return this.session;
        }

        public String toString() {
            return String.format("{directory=%s fromSource=%s toSource=%s}", this.dirName, this.fromSource, this.toSource);
        }
    }
}

