/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.storage.sql.RowId;

public class Invalidations
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARENT = "__PARENT__";
    public static final String SERIES_PROXIES = "__SERIES_PROXIES__";
    public static final String TARGET_PROXIES = "__TARGET_PROXIES__";
    public static final int MODIFIED = 1;
    public static final int DELETED = 2;
    public Set<RowId> modified;
    public Set<RowId> deleted;

    public boolean isEmpty() {
        return this.modified == null && this.deleted == null;
    }

    public void clear() {
        this.modified = null;
        this.deleted = null;
    }

    public boolean contains(RowId rowId) {
        return this.modified != null && this.modified.contains(rowId) || this.deleted != null && this.deleted.contains(rowId);
    }

    public Set<RowId> getKindSet(int kind) {
        switch (kind) {
            case 1: {
                if (this.modified == null) {
                    this.modified = new HashSet<RowId>();
                }
                return this.modified;
            }
            case 2: {
                if (this.deleted == null) {
                    this.deleted = new HashSet<RowId>();
                }
                return this.deleted;
            }
        }
        throw new AssertionError();
    }

    public void add(Invalidations other) {
        if (other == null) {
            return;
        }
        if (other.modified != null) {
            this.addModified(other.modified);
        }
        if (other.deleted != null) {
            this.addDeleted(other.deleted);
        }
    }

    public void addModified(RowId rowId) {
        if (this.modified == null) {
            this.modified = new HashSet<RowId>();
        }
        this.modified.add(rowId);
    }

    public void addModified(Set<RowId> rowIds) {
        if (this.modified == null) {
            this.modified = new HashSet<RowId>();
        }
        this.modified.addAll(rowIds);
    }

    public void addDeleted(RowId rowId) {
        if (this.deleted == null) {
            this.deleted = new HashSet<RowId>();
        }
        this.deleted.add(rowId);
    }

    public void addDeleted(Set<RowId> rowIds) {
        if (this.deleted == null) {
            this.deleted = new HashSet<RowId>();
        }
        this.deleted.addAll(rowIds);
    }

    public void add(Serializable id, String[] tableNames, int kind) {
        if (tableNames.length == 0) {
            return;
        }
        Set<RowId> set = this.getKindSet(kind);
        for (String tableName : tableNames) {
            set.add(new RowId(tableName, id));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + '(');
        if (this.modified != null) {
            sb.append("modified=");
            sb.append(this.modified);
            if (this.deleted != null) {
                sb.append(',');
            }
        }
        if (this.deleted != null) {
            sb.append("deleted=");
            sb.append(this.deleted);
        }
        sb.append(')');
        return sb.toString();
    }

    public static final class InvalidationsPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Invalidations cacheInvalidations;
        public final Invalidations eventInvalidations;

        public InvalidationsPair(Invalidations cacheInvalidations, Invalidations eventInvalidations) {
            this.cacheInvalidations = cacheInvalidations;
            this.eventInvalidations = eventInvalidations;
        }
    }
}

