/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.servlet.Servlet;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.ConnectionSpecImpl;
import org.nuxeo.ecm.core.storage.sql.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.sql.InvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.LockManager;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCBackend;
import org.nuxeo.ecm.core.storage.sql.net.BinaryManagerClient;
import org.nuxeo.ecm.core.storage.sql.net.BinaryManagerServlet;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;
import org.nuxeo.ecm.core.storage.sql.net.MapperServlet;
import org.nuxeo.ecm.core.storage.sql.net.NetBackend;
import org.nuxeo.ecm.core.storage.sql.net.NetServer;
import org.nuxeo.runtime.api.Framework;

public class RepositoryImpl
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    public static final String RUNTIME_SERVER_HOST = "org.nuxeo.runtime.server.host";
    public static final String SERVER_PATH_VCS = "vcs";
    public static final String SERVER_PATH_BINARY = "binary";
    protected final RepositoryDescriptor repositoryDescriptor;
    protected final MultiThreadedHttpConnectionManager connectionManager;
    protected final HttpClient httpClient;
    protected final SchemaManager schemaManager;
    protected final EventService eventService;
    protected final BinaryManager binaryManager;
    private final RepositoryBackend backend;
    private final Collection<SessionImpl> sessions;
    private LockManager lockManager;
    private final InvalidationsPropagator cachePropagator;
    private final InvalidationsPropagator eventPropagator;
    private final InvalidationsQueue repositoryEventQueue;
    private Model model;
    private boolean serverStarted;
    private boolean binaryServerStarted;
    public String repositoryId;
    private Reference reference;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor) throws StorageException {
        this.repositoryDescriptor = repositoryDescriptor;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        this.cachePropagator = new InvalidationsPropagator();
        this.eventPropagator = new InvalidationsPropagator();
        this.repositoryEventQueue = new InvalidationsQueue("repo-" + repositoryDescriptor.name);
        try {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        try {
            this.eventService = (EventService)Framework.getService(EventService.class);
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(20);
        params.setMaxTotalConnections(20);
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.binaryManager = this.createBinaryManager();
        this.backend = this.createBackend();
        this.createServer();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected BinaryManager createBinaryManager() throws StorageException {
        try {
            Class<? extends BinaryManager> klass = this.repositoryDescriptor.binaryManagerClass;
            if (klass == null) {
                klass = DefaultBinaryManager.class;
            }
            BinaryManager binaryManager = klass.newInstance();
            binaryManager.initialize(this.repositoryDescriptor);
            if (this.repositoryDescriptor.binaryManagerConnect) {
                List<RepositoryDescriptor.ServerDescriptor> connect = this.repositoryDescriptor.connect;
                if (connect.isEmpty() || connect.get((int)0).disabled) {
                    log.error((Object)"Repository descriptor specifies binaryManager connect without a global connect");
                } else {
                    binaryManager = new BinaryManagerClient(binaryManager, this.httpClient);
                    binaryManager.initialize(this.repositoryDescriptor);
                }
            }
            if (this.repositoryDescriptor.binaryManagerListen) {
                this.activateBinaryManagerServlet(binaryManager);
            }
            return binaryManager;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected RepositoryBackend createBackend() throws StorageException {
        Class backendClass = this.repositoryDescriptor.backendClass;
        List<RepositoryDescriptor.ServerDescriptor> connect = this.repositoryDescriptor.connect;
        if (backendClass == null) {
            backendClass = !connect.isEmpty() ? NetBackend.class : JDBCBackend.class;
        } else if (!connect.isEmpty()) {
            log.error((Object)"Repository descriptor specifies both backendClass and connect, only the backend will be used.");
        }
        try {
            RepositoryBackend backend = backendClass.newInstance();
            backend.initialize(this);
            return backend;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected void createServer() {
        RepositoryDescriptor.ServerDescriptor serverDescriptor = this.repositoryDescriptor.listen;
        if (serverDescriptor != null && !serverDescriptor.disabled) {
            this.activateServletMapper();
        }
    }

    protected void activateServletMapper() {
        if (!this.serverStarted) {
            MapperServlet servlet = new MapperServlet(this.repositoryDescriptor.name);
            String servletName = MapperServlet.getName(this.repositoryDescriptor.name);
            String url = NetServer.add(this.repositoryDescriptor.listen, servletName, (Servlet)servlet, SERVER_PATH_VCS);
            log.info((Object)String.format("VCS server for repository '%s' started on: %s", this.repositoryDescriptor.name, url));
            this.serverStarted = true;
        }
    }

    protected void deactivateServletMapper() {
        if (this.serverStarted) {
            String servletName = MapperServlet.getName(this.repositoryDescriptor.name);
            NetServer.remove(this.repositoryDescriptor.listen, servletName);
            this.serverStarted = false;
        }
    }

    protected void activateBinaryManagerServlet(BinaryManager binaryManager) {
        if (!this.binaryServerStarted) {
            RepositoryDescriptor.ServerDescriptor serverDescriptor = this.repositoryDescriptor.listen;
            if (serverDescriptor == null || serverDescriptor.disabled) {
                log.error((Object)"Repository descriptor specifies binaryManager listen without a global listen");
            } else {
                BinaryManagerServlet servlet = new BinaryManagerServlet(binaryManager);
                String servletName = BinaryManagerServlet.getName(binaryManager);
                String url = NetServer.add(serverDescriptor, servletName, (Servlet)servlet, SERVER_PATH_BINARY);
                log.info((Object)String.format("VCS server for binary manager of repository '%s' started on: %s", this.repositoryDescriptor.name, url));
                this.binaryServerStarted = true;
            }
        }
    }

    protected void deactivateBinaryManagerServlet() {
        if (this.binaryServerStarted) {
            String servletName = BinaryManagerServlet.getName(this.binaryManager);
            NetServer.remove(this.repositoryDescriptor.listen, servletName);
            this.binaryServerStarted = false;
        }
    }

    @Override
    public boolean isServerActivated() {
        return this.serverStarted;
    }

    @Override
    public String getServerURL() {
        String host = Framework.getProperty((String)RUNTIME_SERVER_HOST, (String)"localhost");
        if (this.repositoryDescriptor.listen != null) {
            return String.format("http://%s:%d/%s", host, this.repositoryDescriptor.listen.port, this.repositoryDescriptor.listen.path);
        }
        return null;
    }

    @Override
    public void activateServer() {
        this.activateServletMapper();
        this.activateBinaryManagerServlet(this.binaryManager);
    }

    @Override
    public void deactivateServer() {
        this.deactivateServletMapper();
        this.deactivateBinaryManagerServlet();
    }

    @Override
    public Collection<MapperClientInfo> getClientInfos() {
        if (!this.serverStarted) {
            return Collections.emptyList();
        }
        MapperServlet servlet = (MapperServlet)NetServer.get(this.repositoryDescriptor.listen, MapperServlet.getName(this.repositoryDescriptor.name));
        return servlet.getClientInfos();
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public SessionImpl getConnection() throws StorageException {
        return this.getConnection(null);
    }

    @Override
    public synchronized SessionImpl getConnection(ConnectionSpec connectionSpec) throws StorageException {
        boolean create;
        assert (connectionSpec == null || connectionSpec instanceof ConnectionSpecImpl);
        Credentials credentials = connectionSpec == null ? null : ((ConnectionSpecImpl)connectionSpec).getCredentials();
        boolean bl = create = this.model == null;
        if (create) {
            log.debug((Object)"Initializing");
            ModelSetup modelSetup = new ModelSetup();
            modelSetup.repositoryDescriptor = this.repositoryDescriptor;
            modelSetup.schemaManager = this.schemaManager;
            this.backend.initializeModelSetup(modelSetup);
            this.model = new Model(modelSetup);
            this.backend.initializeModel(this.model);
            Mapper lockManagerMapper = this.backend.newMapper(this.model, null, credentials, true);
            this.lockManager = new LockManager(lockManagerMapper, this.repositoryDescriptor.clusteringEnabled);
        }
        SessionPathResolver pathResolver = new SessionPathResolver();
        Mapper mapper = this.backend.newMapper(this.model, pathResolver, credentials, false);
        SessionImpl session = this.newSession(this.model, mapper, credentials);
        pathResolver.setSession(session);
        this.sessions.add(session);
        return session;
    }

    protected SessionImpl newSession(Model model, Mapper mapper, Credentials credentials) throws StorageException {
        mapper = new CachingMapper(model, mapper, this.cachePropagator, this.eventPropagator, this.repositoryEventQueue);
        return new SessionImpl(this, model, mapper, credentials);
    }

    public ResourceAdapterMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public RecordFactory getRecordFactory() {
        throw new UnsupportedOperationException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public synchronized void close() throws StorageException {
        this.closeAllSessions();
        this.model = null;
        this.deactivateServletMapper();
        this.deactivateBinaryManagerServlet();
        this.backend.shutdown();
        this.connectionManager.shutdown();
    }

    protected synchronized void closeAllSessions() throws StorageException {
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
        if (this.lockManager != null) {
            this.lockManager.shutdown();
        }
    }

    @Override
    public String getName() {
        return this.repositoryDescriptor.name;
    }

    @Override
    public int getActiveSessionsCount() {
        return this.sessions.size();
    }

    @Override
    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        if (this.lockManager != null) {
            this.lockManager.clearCaches();
        }
        return n;
    }

    @Override
    public void processClusterInvalidationsNext() {
    }

    @Override
    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.binaryManager.getGarbageCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        try {
            SessionImpl conn = this.getConnection();
            try {
                conn.markReferencedBinaries(gc);
            }
            finally {
                conn.close();
            }
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
    }

    public static class SessionPathResolver
    implements Session.PathResolver {
        private Session session;

        protected void setSession(Session session) {
            this.session = session;
        }

        @Override
        public Serializable getIdForPath(String path) throws StorageException {
            Node node = this.session.getNodeByPath(path, null);
            return node == null ? null : node.getId();
        }
    }
}

