/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class SimpleProperty
extends BaseProperty {
    private final SimpleFragment fragment;
    private final String key;

    public SimpleProperty(String name, PropertyType type, boolean readonly, SimpleFragment fragment, String key) {
        super(name, type, readonly);
        this.fragment = fragment;
        this.key = key;
    }

    public Serializable getValue() throws StorageException {
        return this.fragment.get(this.key);
    }

    public String getString() throws StorageException {
        switch (this.type) {
            case STRING: {
                return (String)((Object)this.fragment.get(this.key));
            }
        }
        throw new RuntimeException("Not a String property: " + (Object)((Object)this.type));
    }

    public Long getLong() throws StorageException {
        switch (this.type) {
            case LONG: {
                return (Long)this.fragment.get(this.key);
            }
        }
        throw new RuntimeException("Not a Long property: " + (Object)((Object)this.type));
    }

    public void setValue(Serializable value) throws StorageException {
        this.checkWritable();
        this.fragment.put(this.key, this.type.normalize(value));
    }
}

