/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.security.SecurityManager;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSecurityManager;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.runtime.api.Framework;

public class SQLRepository
implements Repository {
    private static final Log log = LogFactory.getLog(SQLRepository.class);
    public final RepositoryImpl repository;
    private final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    private final SecurityManager securityManager;
    private final String name;
    private boolean initialized;

    public SQLRepository(org.nuxeo.ecm.core.repository.RepositoryDescriptor descriptor) throws Exception {
        this.repository = new RepositoryImpl(SQLRepository.getDescriptor(descriptor));
        this.securityManager = descriptor.getSecurityManagerClass() == null ? new SQLSecurityManager() : descriptor.getSecurityManager();
        this.name = descriptor.getName();
    }

    public static RepositoryDescriptor getDescriptor(org.nuxeo.ecm.core.repository.RepositoryDescriptor descriptor) throws Exception {
        String filename = descriptor.getConfigurationFile();
        XMap xmap = new XMap();
        xmap.register(RepositoryDescriptor.class);
        RepositoryDescriptor sqldescr = (RepositoryDescriptor)xmap.load((InputStream)new FileInputStream(filename));
        sqldescr.name = descriptor.getName();
        return sqldescr;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(Map<String, Serializable> context) throws DocumentException {
        SessionImpl session;
        SQLRepository sQLRepository = this;
        synchronized (sQLRepository) {
            if (!this.initialized) {
                this.initialized = true;
                if (context != null) {
                    context.put("REPOSITORY_FIRST_ACCESS", Boolean.TRUE);
                }
            }
        }
        try {
            session = this.repository.getConnection();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
        return new SQLSession(session, this, context);
    }

    public SchemaManager getTypeManager() {
        return this.schemaManager;
    }

    public SecurityManager getNuxeoSecurityManager() {
        return this.securityManager;
    }

    public void initialize() {
    }

    @Deprecated
    public Session getSession(long sessionId) {
        throw new UnsupportedOperationException("unused");
    }

    public synchronized Session[] getOpenedSessions() {
        return new Session[0];
    }

    public void shutdown() {
        try {
            this.repository.close();
        }
        catch (StorageException e) {
            log.error((Object)"Cannot close repository", (Throwable)((Object)e));
        }
    }

    public int getStartedSessionsCount() {
        return 0;
    }

    public int getClosedSessionsCount() {
        return 0;
    }

    public int getActiveSessionsCount() {
        return 0;
    }

    public boolean supportsTags() {
        return true;
    }
}

