/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;

public class JDBCConnection {
    protected final Model model;
    protected final SQLInfo sqlInfo;
    protected final XADataSource xadatasource;
    private XAConnection xaconnection;
    public Connection connection;
    protected boolean supportsBatchUpdates;
    protected XAResource xaresource;
    protected final JDBCConnectionPropagator connectionPropagator;
    protected volatile boolean checkConnectionValid;
    public boolean countExecutes;
    public int executeCount;
    private static final AtomicLong instanceCounter = new AtomicLong(0L);
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final JDBCLogger logger = new JDBCLogger(String.valueOf(this.instanceNumber));

    public JDBCConnection(Model model, SQLInfo sqlInfo, XADataSource xadatasource, JDBCConnectionPropagator connectionPropagator) throws StorageException {
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.xadatasource = xadatasource;
        this.connectionPropagator = connectionPropagator;
        connectionPropagator.addConnection(this);
        this.open();
    }

    public Mapper.Identification getIdentification() {
        return new Mapper.Identification(null, "" + this.instanceNumber);
    }

    protected void countExecute() {
        if (this.countExecutes) {
            ++this.executeCount;
        }
    }

    protected void open() throws StorageException {
        this.openConnections();
    }

    private void openConnections() throws StorageException {
        try {
            this.xaconnection = this.xadatasource.getXAConnection();
            this.connection = this.xaconnection.getConnection();
            this.supportsBatchUpdates = this.connection.getMetaData().supportsBatchUpdates();
            this.xaresource = this.xaconnection.getXAResource();
            this.sqlInfo.dialect.performPostOpenStatements(this.connection);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    public void close() {
        this.connectionPropagator.removeConnection(this);
        this.closeConnections();
        this.xaresource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.checkConnectionValid = true;
            }
            finally {
                this.connection = null;
            }
        }
        if (this.xaconnection != null) {
            try {
                this.xaconnection.close();
            }
            catch (SQLException e) {
                this.checkConnectionValid = true;
            }
            finally {
                this.xaconnection = null;
            }
        }
    }

    protected void resetConnection() throws StorageException {
        this.logger.error("Resetting connection");
        this.closeConnections();
        this.openConnections();
        this.connectionPropagator.checkConnectionValid(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionValid() throws StorageException {
        if (this.checkConnectionValid) {
            block15: {
                if (this.connection == null) {
                    this.resetConnection();
                }
                Statement st = null;
                try {
                    st = this.connection.createStatement();
                    st.execute(this.sqlInfo.dialect.getValidationQuery());
                }
                catch (Exception e) {
                    if (this.sqlInfo.dialect.isConnectionClosedException(e)) {
                        this.resetConnection();
                        break block15;
                    }
                    throw new StorageException(e);
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.checkConnectionValid = false;
        }
    }

    protected void checkConnectionReset(Throwable t) throws StorageException {
        if (this.connection == null || this.sqlInfo.dialect.isConnectionClosedException(t)) {
            this.resetConnection();
        }
    }

    protected void checkConnectionReset(XAException e) {
        if (this.connection == null || this.sqlInfo.dialect.isConnectionClosedException(e)) {
            try {
                this.resetConnection();
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement s) throws SQLException {
        try {
            s.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

