/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectSQLServer
extends Dialect {
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_FULLTEXT_CATALOG = "nuxeo";
    protected final String fulltextAnalyzer;
    protected final String fulltextCatalog;
    private static final String DEFAULT_USERS_SEPARATOR = "|";
    protected final String usersSeparator;
    protected boolean pathOptimizationsEnabled;

    public DialectSQLServer(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        String string = repositoryDescriptor == null ? null : (this.fulltextAnalyzer = repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer);
        String string2 = repositoryDescriptor == null ? null : (this.fulltextCatalog = repositoryDescriptor.fulltextCatalog == null ? DEFAULT_FULLTEXT_CATALOG : repositoryDescriptor.fulltextCatalog);
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        this.pathOptimizationsEnabled = repositoryDescriptor == null ? false : repositoryDescriptor.pathOptimizationsEnabled;
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getNullColumnString() {
        return " NULL";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectSQLServer.jdbcInfo("NVARCHAR(4000)", 12);
                }
                if (type.isClob() || type.length > 4000) {
                    return DialectSQLServer.jdbcInfo("NVARCHAR(MAX)", 2005);
                }
                return DialectSQLServer.jdbcInfo("NVARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectSQLServer.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return DialectSQLServer.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectSQLServer.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return DialectSQLServer.jdbcInfo("DATETIME", 93);
            }
            case BLOBID: {
                return DialectSQLServer.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectSQLServer.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectSQLServer.jdbcInfo("VARCHAR(256)", 12);
            }
            case TINYINT: {
                return DialectSQLServer.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return DialectSQLServer.jdbcInfo("INT", 4);
            }
            case AUTOINC: {
                return DialectSQLServer.jdbcInfo("INT IDENTITY", 4);
            }
            case FTINDEXED: {
                throw new AssertionError(type);
            }
            case FTSTORED: {
                return DialectSQLServer.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case CLUSTERNODE: {
                return DialectSQLServer.jdbcInfo("SMALLINT", 5);
            }
            case CLUSTERFRAGS: {
                return DialectSQLServer.jdbcInfo("VARCHAR(8000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("CREATE FULLTEXT INDEX ON %s (", table.getQuotedName()));
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            buf.append(String.format("%s LANGUAGE %s", it.next().getQuotedName(), this.getQuotedFulltextAnalyzer()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        String fulltextUniqueIndex = "[fulltext_pk]";
        buf.append(String.format(") KEY INDEX %s ON [%s]", fulltextUniqueIndex, this.fulltextCatalog));
        return buf.toString();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        Dialect.FulltextQuery ft = DialectSQLServer.analyzeFulltextQuery(query = query.replace("*", "%"));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return DialectSQLServer.translateFulltext(ft, "OR", "AND", "AND NOT", "\"");
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String tableAlias = "_nxfttbl" + nthSuffix;
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>();
        if (nthMatch == 1) {
            info.joins.add(new Join(2, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.joins.add(new Join(2, String.format("CONTAINSTABLE(%s, *, ?, LANGUAGE %s)", ft.getQuotedName(), this.getQuotedFulltextAnalyzer()), tableAlias, fulltextQuery, ftMain.getFullQuotedName(), String.format("%s.[KEY]", tableAlias)));
        info.whereExpr = String.format("%s.[KEY] IS NOT NULL", tableAlias);
        info.scoreExpr = String.format("(%s.RANK / 1000.0)", tableAlias);
        info.scoreAlias = "_nxscore" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    protected String getQuotedFulltextAnalyzer() {
        if (!Character.isDigit(this.fulltextAnalyzer.charAt(0))) {
            return String.format("'%s'", this.fulltextAnalyzer);
        }
        return this.fulltextAnalyzer;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("dbo.NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        if (this.pathOptimizationsEnabled) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND ancestor = ?)", idColumnName);
        }
        return String.format("dbo.NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/sqlserver.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR(36)"));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextCatalog", (Serializable)((Object)this.fulltextCatalog));
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        String[] permissions = NXCore.getSecurityService().getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add(String.format("  SELECT '%s' ", perm));
        }
        properties.put("readPermissions", (Serializable)((Object)StringUtils.join(permsList, (String)" UNION ALL ")));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        return properties;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT acl_id FROM dbo.nx_get_read_acls_for(?))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "EXEC dbo.nx_update_read_acls";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "EXEC dbo.nx_rebuild_read_acls";
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "EXEC dbo.NX_CLUSTER_INVAL ?, ?, ?";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "DELETE I OUTPUT DELETED.[id], DELETED.[fragments], DELETED.[kind] FROM [cluster_invals] AS I WHERE I.[nodeid] = @@SPID";
    }

    @Override
    public boolean isConnectionClosedException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        String message = t.getMessage();
        return message.contains("the Connection object is closed");
    }

    @Override
    public String getBlobLengthFunction() {
        return "DATALENGTH";
    }

    @Override
    public String getPrepareUserReadAclsSql() {
        return "EXEC nx_prepare_user_read_acls ?";
    }

    @Override
    public boolean needsPrepareUserReadAcls() {
        return true;
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPostOpenStatements(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        try {
            stmt.execute("SET TRANSACTION ISOLATION LEVEL SNAPSHOT;");
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public String getAncestorsIdsSql() {
        return "SELECT id FROM dbo.NX_ANCESTORS(?)";
    }
}

