/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;

public class ConnectionAwareXAResource
implements XAResource {
    private final XAResource xaresource;
    private final ManagedConnectionImpl managedConnection;

    public ConnectionAwareXAResource(XAResource xaresource, ManagedConnectionImpl managedConnection) {
        this.xaresource = xaresource;
        this.managedConnection = managedConnection;
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        if (!(other instanceof ConnectionAwareXAResource)) {
            return false;
        }
        return this.xaresource.isSameRM(((ConnectionAwareXAResource)other).xaresource);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.xaresource.start(xid, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
        }
        finally {
            this.managedConnection.closeConnections();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.xaresource.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.xaresource.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.xaresource.rollback(xid);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }
}

