/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.web;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.jbpm.AbstractJbpmHandlerHelper;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmSecurityPolicy;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.TaskListFilter;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.ecm.platform.jbpm.operations.AddCommentOperation;
import org.nuxeo.ecm.platform.jbpm.operations.GetRecipientsForTaskOperation;
import org.nuxeo.ecm.platform.jbpm.web.JbpmActions;
import org.nuxeo.ecm.platform.jbpm.web.JbpmHelper;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="jbpmActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class JbpmActionsBean
extends DocumentContextBoundActionBean
implements JbpmActions {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient JbpmService jbpmService;
    @In(create=true)
    protected transient JbpmHelper jbpmHelper;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient NuxeoPrincipal currentUser;
    protected Boolean canManageCurrentProcess;
    protected Boolean canManageParticipants;
    protected ProcessInstance currentProcess;
    protected String currentProcessInitiator;
    protected String currentProcessDestinationState;
    protected List<TaskInstance> currentTasks;
    protected ArrayList<VirtualTaskInstance> currentVirtualTasks;
    protected VirtualTaskInstance newVirtualTask;
    protected Boolean showAddVirtualTaskForm;
    protected Boolean formInEditMode = Boolean.FALSE;
    protected String userComment;
    protected static Set<String> CHECK_IN_TRANSITIONS = new HashSet<String>(Arrays.asList("approve"));

    @Override
    public boolean getCanCreateProcess() throws ClientException {
        DocumentModel currentDoc;
        ProcessInstance currentProcess = this.getCurrentProcess();
        if (currentProcess == null && (currentDoc = this.navigationContext.getCurrentDocument()) != null) {
            DocumentRef docRef = currentDoc.getRef();
            return this.documentManager.hasPermission(docRef, "Write");
        }
        return false;
    }

    @Override
    public boolean getCanManageProcess() throws ClientException {
        if (this.canManageCurrentProcess == null) {
            Boolean canWrite;
            this.canManageCurrentProcess = Boolean.FALSE;
            ProcessInstance currentProcess = this.getCurrentProcess();
            if (currentProcess != null && (canWrite = this.jbpmService.getPermission(currentProcess, JbpmSecurityPolicy.Action.write, this.navigationContext.getCurrentDocument(), this.currentUser)) != null) {
                this.canManageCurrentProcess = canWrite;
            }
        }
        return this.canManageCurrentProcess;
    }

    @Override
    public boolean getCanManageParticipants() throws ClientException {
        if (this.canManageParticipants == null) {
            this.canManageParticipants = Boolean.FALSE;
            if (this.getCanManageProcess()) {
                this.canManageParticipants = Boolean.TRUE;
            } else {
                List tasks;
                ProcessInstance pi = this.getCurrentProcess();
                if (pi != null && (tasks = this.jbpmService.getTaskInstances(Long.valueOf(this.currentProcess.getId()), null, null)) != null && !tasks.isEmpty()) {
                    JbpmHelper helper = new JbpmHelper();
                    NuxeoPrincipal pal = this.currentUser;
                    for (TaskInstance task : tasks) {
                        if (task.isCancelled() || task.hasEnded() || !helper.isTaskAssignedToUser(task, pal)) continue;
                        this.canManageParticipants = Boolean.TRUE;
                        break;
                    }
                }
            }
            if (Boolean.TRUE.equals(this.canManageParticipants) && this.isProcessStarted("choose-participant") && "review_parallel".equals(this.getCurrentProcess().getProcessDefinition().getName())) {
                this.canManageParticipants = Boolean.FALSE;
            }
        }
        return this.canManageParticipants;
    }

    @Override
    public boolean getCanEndTask(TaskInstance taskInstance) throws ClientException {
        if (taskInstance != null && !taskInstance.isCancelled() && !taskInstance.hasEnded()) {
            JbpmHelper helper = new JbpmHelper();
            NuxeoPrincipal pal = this.currentUser;
            return pal.isAdministrator() || pal.getName().equals(this.getCurrentProcessInitiator()) || helper.isTaskAssignedToUser(taskInstance, pal);
        }
        return false;
    }

    @Override
    public String createProcessInstance(NuxeoPrincipal principal, String pd, DocumentModel dm, String endLifeCycle) throws ClientException {
        if (this.getCanCreateProcess()) {
            HashMap<String, String> map = null;
            if (endLifeCycle != null && !endLifeCycle.equals("") && !"null".equals(endLifeCycle)) {
                map = new HashMap<String, String>();
                map.put(JbpmService.VariableName.endLifecycleTransition.name(), endLifeCycle);
            }
            this.jbpmService.createProcessInstance(principal, pd, dm, map, null);
            this.notifyEventListeners("workflowNewProcessStarted", "", new String[]{"user:" + principal.getName()});
            Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public ProcessInstance getCurrentProcess() throws ClientException {
        List processes;
        if (this.currentProcess == null && (processes = this.jbpmService.getProcessInstances(this.navigationContext.getCurrentDocument(), this.currentUser, null)) != null && !processes.isEmpty()) {
            this.currentProcess = (ProcessInstance)processes.get(0);
        }
        return this.currentProcess;
    }

    @Override
    public String getCurrentProcessInitiator() throws ClientException {
        if (this.currentProcessInitiator == null) {
            Object initiator;
            this.currentProcessInitiator = "";
            ProcessInstance currentProcess = this.getCurrentProcess();
            if (currentProcess != null && (initiator = currentProcess.getContextInstance().getVariable(JbpmService.VariableName.initiator.name())) instanceof String) {
                this.currentProcessInitiator = (String)initiator;
                if (this.currentProcessInitiator.startsWith("user:")) {
                    this.currentProcessInitiator = this.currentProcessInitiator.substring("user:".length());
                }
            }
        }
        return this.currentProcessInitiator;
    }

    public String getCurrentProcessDestinationState() throws ClientException {
        Object destinationState;
        ProcessInstance currentProcess;
        if (this.currentProcessDestinationState == null && (currentProcess = this.getCurrentProcess()) != null && (destinationState = currentProcess.getContextInstance().getVariable(JbpmService.VariableName.endLifecycleTransition.name())) instanceof String) {
            this.currentProcessDestinationState = (String)destinationState;
        }
        return this.currentProcessDestinationState;
    }

    @Override
    public List<TaskInstance> getCurrentTasks(String ... taskNames) throws ClientException {
        if (this.currentTasks == null) {
            this.currentTasks = new ArrayList<TaskInstance>();
            ProcessInstance currentProcess = this.getCurrentProcess();
            if (currentProcess != null) {
                this.currentTasks.addAll(this.jbpmService.getTaskInstances(Long.valueOf(currentProcess.getId()), null, (JbpmListFilter)new TaskListFilter(taskNames)));
            }
        }
        return this.currentTasks;
    }

    @Override
    public ArrayList<VirtualTaskInstance> getCurrentVirtualTasks() throws ClientException {
        if (this.currentVirtualTasks == null) {
            Object participants;
            this.currentVirtualTasks = new ArrayList();
            ProcessInstance currentProcess = this.getCurrentProcess();
            if (currentProcess != null && (participants = currentProcess.getContextInstance().getVariable(JbpmService.VariableName.participants.name())) != null && participants instanceof List) {
                this.currentVirtualTasks.addAll((List)participants);
            }
        }
        return this.currentVirtualTasks;
    }

    @Override
    public boolean getShowAddVirtualTaskForm() throws ClientException {
        if (this.showAddVirtualTaskForm == null) {
            this.showAddVirtualTaskForm = Boolean.FALSE;
            if (this.getCurrentVirtualTasks().isEmpty() && (this.currentTasks == null || this.currentTasks.isEmpty())) {
                this.showAddVirtualTaskForm = Boolean.TRUE;
            }
        }
        return this.showAddVirtualTaskForm;
    }

    @Override
    public void toggleShowAddVirtualTaskForm(ActionEvent event) throws ClientException {
        this.showAddVirtualTaskForm = !this.getShowAddVirtualTaskForm();
    }

    @Override
    public VirtualTaskInstance getNewVirtualTask() {
        if (this.newVirtualTask == null) {
            this.newVirtualTask = new VirtualTaskInstance();
        }
        return this.newVirtualTask;
    }

    @Override
    public String addNewVirtualTask() throws ClientException {
        ProcessInstance pi = this.getCurrentProcess();
        if (pi != null && this.newVirtualTask != null && this.getCanManageParticipants()) {
            ArrayList<Object> virtualTasks = this.getCurrentVirtualTasks();
            if (virtualTasks == null) {
                virtualTasks = new ArrayList();
            }
            virtualTasks.add(this.newVirtualTask);
            pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.added.reviewer"), new Object[0]);
            this.resetCurrentData();
            this.showAddVirtualTaskForm = Boolean.TRUE;
        }
        return null;
    }

    public String persistProcessInstance() throws ClientException {
        ProcessInstance pi = this.getCurrentProcess();
        if (pi != null) {
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.task.edited"), new Object[0]);
            this.resetCurrentData();
            this.formInEditMode = Boolean.FALSE;
        }
        return null;
    }

    public String changeVirtualTaskModification() {
        this.formInEditMode = this.formInEditMode == false;
        if (!Boolean.TRUE.equals(this.formInEditMode)) {
            this.resetCurrentData();
        }
        return null;
    }

    public Boolean getFormInEditMode() {
        return this.formInEditMode;
    }

    @Override
    public String moveDownVirtualTask(int index) throws ClientException {
        ProcessInstance pi = this.getCurrentProcess();
        if (pi != null && this.getCanManageParticipants()) {
            ArrayList<VirtualTaskInstance> virtualTasks = this.getCurrentVirtualTasks();
            if (virtualTasks != null && index + 1 < virtualTasks.size()) {
                VirtualTaskInstance task = (VirtualTaskInstance)virtualTasks.remove(index);
                virtualTasks.add(index + 1, task);
            }
            pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.movedUp.reviewer"), new Object[0]);
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public String moveUpVirtualTask(int index) throws ClientException {
        ProcessInstance pi = this.getCurrentProcess();
        if (pi != null && this.getCanManageParticipants()) {
            ArrayList<VirtualTaskInstance> virtualTasks = this.getCurrentVirtualTasks();
            if (virtualTasks != null && index - 1 < virtualTasks.size()) {
                VirtualTaskInstance task = (VirtualTaskInstance)virtualTasks.remove(index);
                virtualTasks.add(index - 1, task);
            }
            pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.movedDown.reviewer"), new Object[0]);
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public String removeVirtualTask(int index) throws ClientException {
        ProcessInstance pi = this.getCurrentProcess();
        if (pi != null && this.getCanManageParticipants()) {
            ArrayList<VirtualTaskInstance> virtualTasks = this.getCurrentVirtualTasks();
            if (virtualTasks != null && index < virtualTasks.size()) {
                virtualTasks.remove(index);
            }
            pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
            this.jbpmService.persistProcessInstance(pi);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.removed.reviewer"), new Object[0]);
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public void validateTaskDueDate(FacesContext context, UIComponent component, Object value) {
        String DATE_FORMAT = "dd/MM/yyyy";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String messageString = null;
        if (value != null) {
            Date today = null;
            Date dueDate = null;
            try {
                dueDate = dateFormat.parse(dateFormat.format((Date)value));
                today = dateFormat.parse(dateFormat.format(new Date()));
            }
            catch (ParseException e) {
                messageString = "label.workflow.error.date_parsing";
            }
            if (dueDate.before(today)) {
                messageString = "label.workflow.error.outdated_duedate";
            }
        }
        if (messageString != null) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.workflow.error.outdated_duedate"), null);
            ((EditableValueHolder)component).setValid(false);
            context.addMessage(component.getClientId(context), message);
        }
    }

    protected TaskInstance getStartTask(String taskName) throws ClientException {
        List tasks;
        ProcessInstance pi;
        TaskInstance startTask = null;
        if (taskName != null && (pi = this.getCurrentProcess()) != null && (tasks = this.jbpmService.getTaskInstances(Long.valueOf(this.currentProcess.getId()), null, (JbpmListFilter)new TaskListFilter(new String[]{taskName}))) != null && !tasks.isEmpty()) {
            startTask = (TaskInstance)tasks.get(0);
        }
        if (startTask == null) {
            throw new ClientException("No start task found on current process with name " + taskName);
        }
        return startTask;
    }

    @Override
    public boolean isProcessStarted(String startTaskName) throws ClientException {
        TaskInstance startTask = this.getStartTask(startTaskName);
        return startTask.hasEnded();
    }

    @Override
    public String startProcess(String startTaskName) throws ClientException {
        if (this.getCanManageProcess()) {
            TaskInstance startTask = this.getStartTask(startTaskName);
            if (startTask.hasEnded()) {
                throw new ClientException("Process is already started");
            }
            HashMap<String, ArrayList<Object>> transientVariables = new HashMap<String, ArrayList<Object>>();
            transientVariables.put(JbpmService.VariableName.participants.name(), this.getCurrentVirtualTasks());
            transientVariables.put(JbpmService.VariableName.document.name(), (ArrayList<Object>)this.navigationContext.getCurrentDocument());
            transientVariables.put(JbpmService.VariableName.principal.name(), (ArrayList<Object>)this.currentUser);
            this.jbpmService.endTask(Long.valueOf(startTask.getId()), null, null, null, transientVariables, this.currentUser);
            this.documentManager.save();
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public String validateTask(TaskInstance taskInstance, String transition) throws ClientException {
        if (taskInstance != null) {
            if (this.userComment != null && !"".equals(this.userComment)) {
                AddCommentOperation addCommentOperation = new AddCommentOperation(taskInstance.getId(), "user:" + this.currentUser.getName(), this.userComment);
                this.jbpmService.executeJbpmOperation((JbpmOperation)addCommentOperation);
            }
            HashMap<String, Boolean> taskVariables = new HashMap<String, Boolean>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), Boolean.TRUE);
            this.jbpmService.endTask(Long.valueOf(taskInstance.getId()), transition, taskVariables, null, this.getTransientVariables(), this.currentUser);
            this.documentManager.save();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.task.ended"), new Object[0]);
            Set<String> recipients = this.getRecipientsFromTask(taskInstance);
            this.notifyEventListeners("workflowTaskCompleted", this.userComment, recipients.toArray(new String[0]));
            Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
            this.resetCurrentData();
        }
        return this.returnToCurrentDocOrHome();
    }

    @Override
    public String rejectTask(TaskInstance taskInstance, String transition) throws ClientException {
        if (taskInstance != null) {
            if (this.userComment == null || "".equals(this.userComment)) {
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.review.task.enterComment"), new Object[0]);
                return null;
            }
            AddCommentOperation addCommentOperation = new AddCommentOperation(taskInstance.getId(), "user:" + this.currentUser.getName(), this.userComment);
            this.jbpmService.executeJbpmOperation((JbpmOperation)addCommentOperation);
            HashMap<String, Boolean> taskVariables = new HashMap<String, Boolean>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), Boolean.FALSE);
            this.jbpmService.endTask(Long.valueOf(taskInstance.getId()), transition, taskVariables, null, this.getTransientVariables(), this.currentUser);
            this.documentManager.save();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.review.task.ended"), new Object[0]);
            Set<String> recipients = this.getRecipientsFromTask(taskInstance);
            this.notifyEventListeners("workflowTaskRejected", this.userComment, recipients.toArray(new String[0]));
            Events.instance().raiseEvent("workflowTaskRejected", new Object[0]);
            this.resetCurrentData();
        }
        return this.returnToCurrentDocOrHome();
    }

    protected String returnToCurrentDocOrHome() throws ClientException {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            currentDocument = this.documentManager.getDocument(currentDocument.getRef());
            this.getCurrentProcess();
            String currentTabId = this.webActions.getCurrentTabId();
            this.navigationContext.setCurrentDocument(null);
            if (this.currentProcess == null || this.currentProcess.hasEnded()) {
                return this.navigationContext.navigateToDocument(currentDocument);
            }
            return this.webActions.setCurrentTabAndNavigate(currentDocument, currentTabId);
        }
        catch (DocumentSecurityException e) {
            this.navigationContext.setCurrentDocument(null);
            return this.navigationContext.goHome();
        }
    }

    protected Map<String, Serializable> getTransientVariables() {
        HashMap<String, Serializable> transientVariables = new HashMap<String, Serializable>();
        transientVariables.put(JbpmService.VariableName.document.name(), (Serializable)this.navigationContext.getCurrentDocument());
        transientVariables.put(JbpmService.VariableName.principal.name(), (Serializable)this.currentUser);
        return transientVariables;
    }

    protected Set<String> getRecipientsFromTask(TaskInstance taskInstance) throws NuxeoJbpmException {
        GetRecipientsForTaskOperation operation = new GetRecipientsForTaskOperation(taskInstance.getId());
        return (Set)((Object)this.jbpmService.executeJbpmOperation((JbpmOperation)operation));
    }

    public String cancelCurrentProcess() throws ClientException {
        ProcessInstance currentProcess = this.getCurrentProcess();
        if (currentProcess != null) {
            Long pid = currentProcess.getId();
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (currentDoc != null) {
                UnrestrictedAbandon runner = new UnrestrictedAbandon(currentDoc.getRef(), pid);
                runner.runUnrestricted();
            }
            UnrestrictedEndProcess endProcessRunner = new UnrestrictedEndProcess(currentDoc.getRef());
            endProcessRunner.runUnrestricted();
            this.jbpmService.deleteProcessInstance(this.currentUser, pid);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("workflowProcessCanceled"), new Object[0]);
            this.notifyEventListeners("workflowProcessCanceled", this.userComment, endProcessRunner.recipients.toArray(new String[0]));
            Events.instance().raiseEvent("workflowProcessCanceled", new Object[0]);
            this.resetCurrentData();
        }
        this.webActions.resetCurrentTab();
        return null;
    }

    @Override
    public String abandonCurrentProcess() throws ClientException {
        ProcessInstance currentProcess = this.getCurrentProcess();
        if (currentProcess != null && this.getCanManageProcess()) {
            Long pid = currentProcess.getId();
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (currentDoc != null) {
                UnrestrictedAbandon runner = new UnrestrictedAbandon(currentDoc.getRef(), pid);
                runner.runUnrestricted();
            }
            List tis = this.jbpmService.getTaskInstances(this.navigationContext.getCurrentDocument(), (NuxeoPrincipal)null, null);
            HashSet<String> recipients = new HashSet<String>();
            for (TaskInstance ti : tis) {
                String actor = ti.getActorId();
                recipients.add(actor);
                Set pooledActors = ti.getPooledActors();
                for (PooledActor pa : pooledActors) {
                    recipients.add(pa.getActorId());
                }
            }
            this.jbpmService.deleteProcessInstance(this.currentUser, pid);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("workflowAbandoned"), new Object[0]);
            this.notifyEventListeners("workflowAbandoned", this.userComment, recipients.toArray(new String[0]));
            Events.instance().raiseEvent("workflowAbandoned", new Object[0]);
            this.resetCurrentData();
        }
        return null;
    }

    @Override
    public String getUserComment() {
        return this.userComment;
    }

    @Override
    public void setUserComment(String comment) {
        this.userComment = comment;
    }

    protected boolean isCheckInTransition(String transition) {
        return CHECK_IN_TRANSITIONS.contains(transition);
    }

    @Override
    public List<String> getAllowedStateTransitions(DocumentRef ref) throws ClientException {
        ArrayList<String> res = new ArrayList<String>();
        for (String transition : this.documentManager.getAllowedStateTransitions(ref)) {
            if (this.isCheckInTransition(transition)) {
                res.add(transition + "_MINOR");
                res.add(transition + "_MAJOR");
                continue;
            }
            res.add(transition);
        }
        return res;
    }

    @Override
    public void resetCurrentData() {
        this.canManageCurrentProcess = null;
        this.canManageParticipants = null;
        this.currentProcess = null;
        this.currentProcessInitiator = null;
        this.currentProcessDestinationState = null;
        this.currentTasks = null;
        this.currentVirtualTasks = null;
        this.newVirtualTask = null;
        this.showAddVirtualTaskForm = null;
        this.userComment = null;
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.resetCurrentData();
    }

    public void notifyEventListeners(String name, String comment, String[] recipients) throws ClientException {
        this.jbpmService.notifyEventListeners(name, comment, recipients, this.documentManager, this.currentUser, this.getCurrentDocument());
    }

    @Override
    public boolean hasProcessDefinitions(String documentType) {
        Map conf = this.jbpmService.getTypeFilterConfiguration();
        if (conf != null) {
            List defNames = (List)conf.get(documentType);
            return defNames != null && !defNames.isEmpty();
        }
        return false;
    }

    protected class UnrestrictedEndProcess
    extends UnrestrictedSessionRunner {
        private final DocumentRef ref;
        public Set<String> recipients;

        protected UnrestrictedEndProcess(DocumentRef ref) {
            super(JbpmActionsBean.this.documentManager);
            this.ref = ref;
        }

        public void run() throws ClientException {
            List tis = JbpmActionsBean.this.jbpmService.getTaskInstances(this.session.getDocument(this.ref), (NuxeoPrincipal)null, null);
            this.recipients = new HashSet<String>();
            for (TaskInstance ti : tis) {
                String actor = ti.getActorId();
                this.recipients.add(actor);
                Set pooledActors = ti.getPooledActors();
                for (PooledActor pa : pooledActors) {
                    this.recipients.add(pa.getActorId());
                }
            }
        }
    }

    protected class UnrestrictedAbandon
    extends UnrestrictedSessionRunner {
        private final DocumentRef ref;
        private final Long processId;

        protected UnrestrictedAbandon(DocumentRef ref, Long processId) {
            super(JbpmActionsBean.this.documentManager);
            this.ref = ref;
            this.processId = processId;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getDocument(this.ref);
            ACP acp = doc.getACP();
            acp.removeACL(AbstractJbpmHandlerHelper.getProcessACLName((Long)this.processId));
            this.session.setACP(doc.getRef(), acp, true);
            this.session.save();
        }
    }
}

