/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import org.jboss.seam.core.Events;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Seam.Refresh", category="User Interface", requires="Seam", label="Refresh", description="Refresh the UI cache. This is a void operation - the input object is returned back as the oputput")
public class RefreshUI {
    public static final String ID = "Seam.Refresh";
    @Param(name="additional list of seam events to raise", required=false)
    protected StringList additionalSeamEvents;

    @OperationMethod
    public void run() {
        OperationHelper.getContentViewActions().resetAllContent();
        NavigationContext context = OperationHelper.getNavigationContext();
        DocumentModel dm = context.getCurrentDocument();
        if (dm != null) {
            Events.instance().raiseEvent("documentChanged", new Object[]{dm});
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{dm});
            Events.instance().raiseEvent("domainSelectionChanged", new Object[]{dm});
        }
        if (this.additionalSeamEvents != null) {
            for (String event : this.additionalSeamEvents) {
                Events.instance().raiseEvent(event, new Object[0]);
            }
        }
    }
}

