/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.tx;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class EventBundleTransactionHandler {
    private static final Log log = LogFactory.getLog(EventBundleTransactionHandler.class);
    protected UserTransaction tx;
    protected boolean disabled;

    public void beginNewTransaction() {
        this.beginNewTransaction(null);
    }

    public void beginNewTransaction(Integer transactionTimeout) {
        if (this.disabled) {
            return;
        }
        if (this.tx != null) {
            throw new UnsupportedOperationException("There is already an uncommited transaction running");
        }
        this.tx = this.createUT(transactionTimeout);
        if (this.tx == null) {
            log.debug((Object)"No TransactionManager");
            this.disabled = true;
            return;
        }
        try {
            if (this.tx.getStatus() == 3) {
                log.error((Object)"Transaction is already commited, try to begin anyway");
            }
            this.tx.begin();
        }
        catch (Exception e) {
            log.error((Object)"Unable to start transaction", (Throwable)e);
        }
    }

    protected UserTransaction createUT(Integer transactionTimeout) {
        return this.createUT(transactionTimeout, false);
    }

    protected UserTransaction createUT(Integer transactionTimeout, boolean retry) {
        UserTransaction ut;
        block11: {
            try {
                new InitialContext();
            }
            catch (Exception e) {
                this.disabled = true;
                return null;
            }
            try {
                ut = TransactionHelper.lookupUserTransaction();
            }
            catch (NamingException e) {
                this.disabled = true;
                return null;
            }
            try {
                int txStatus = ut.getStatus();
                if (txStatus == 6 || retry) break block11;
                log.warn((Object)"Transaction was not properly cleanup up from thread context, rolling back before getting a new tx");
                try {
                    ut.rollback();
                }
                catch (Throwable t) {
                    log.warn((Object)"error during tx rollback", t);
                }
                return this.createUT(transactionTimeout, true);
            }
            catch (Exception se) {
                log.warn((Object)"Error while getting TX status", (Throwable)se);
            }
        }
        if (transactionTimeout != null) {
            try {
                ut.setTransactionTimeout(transactionTimeout.intValue());
            }
            catch (SystemException e) {
                log.error((Object)("Error while setting transaction timeout to " + transactionTimeout), (Throwable)e);
            }
        }
        return ut;
    }

    protected boolean isUTTransactionActive() {
        try {
            return this.tx.getStatus() == 0;
        }
        catch (SystemException e) {
            log.error((Object)"Error while getting tx status", (Throwable)e);
            return false;
        }
    }

    private boolean isUTTransactionMarkedRollback() {
        try {
            int status = this.tx.getStatus();
            return status == 1 || status == 4;
        }
        catch (SystemException e) {
            log.error((Object)"Error while getting tx status", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        if (this.disabled || this.tx == null) {
            return;
        }
        try {
            if (!this.isUTTransactionMarkedRollback()) {
                this.tx.setRollbackOnly();
            }
            this.commitOrRollbackTransaction();
        }
        catch (Exception e) {
            log.error((Object)"Error while marking tx for rollback", (Throwable)e);
        }
        finally {
            this.tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitOrRollbackTransaction() {
        if (this.disabled || this.tx == null) {
            return;
        }
        try {
            if (this.isUTTransactionActive()) {
                try {
                    this.tx.commit();
                }
                catch (Exception e) {
                    log.error((Object)"Error during commit", (Throwable)e);
                }
            } else {
                try {
                    log.debug((Object)"Rolling back transaction");
                    this.tx.rollback();
                }
                catch (Exception e) {
                    log.debug((Object)"Error during rollback", (Throwable)e);
                }
            }
        }
        finally {
            this.tx = null;
        }
    }

    public void setTransactionRollbackOnly() {
        if (this.disabled || this.tx == null) {
            return;
        }
        try {
            this.tx.setRollbackOnly();
        }
        catch (Exception e) {
            log.error((Object)"Exception caught while setting the transaction as rollback only", (Throwable)e);
        }
    }
}

