/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class DiscoveryService {
    private DiscoveryService() {
    }

    public static void query(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        Boolean searchAllVersions;
        String statement = HttpUtils.getStringParameter(request, "q");
        ObjectList results = service.query(repositoryId, statement, searchAllVersions = HttpUtils.getBooleanParameter(request, "searchAllVersions"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (results == null) {
            throw new CmisRuntimeException("Results are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonResults = JSONConverter.convert(results, typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonResults, request, response);
    }

    public static void getContentChanges(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String changeLogToken = HttpUtils.getStringParameter(request, "changeLogToken");
        Boolean includeProperties = HttpUtils.getBooleanParameter(request, "includeProperties");
        String filter = HttpUtils.getStringParameter(request, "filter");
        Boolean includePolicyIds = HttpUtils.getBooleanParameter(request, "includePolicyIds");
        Boolean includeAcl = HttpUtils.getBooleanParameter(request, "includeACL");
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
        ObjectList changes = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, null);
        JSONObject jsonChanges = new JSONObject();
        jsonChanges.put((Object)"changeLogToken", changeLogTokenHolder.getValue());
        TypeCache typeCache = new TypeCache(repositoryId, service);
        jsonChanges.put((Object)"objects", (Object)JSONConverter.convert(changes, typeCache));
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChanges, request, response);
    }
}

