/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class PolicyService {
    public static void getAppliedPolicies(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String filter = HttpUtils.getStringParameter(request, "filter");
        List policies = service.getAppliedPolicies(repositoryId, objectId, filter, null);
        JSONArray jsonPolicies = new JSONArray();
        if (policies != null) {
            TypeCache typeCache = new TypeCache(repositoryId, service);
            for (ObjectData policy : policies) {
                jsonPolicies.add((Object)JSONConverter.convert(policy, typeCache));
            }
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonPolicies, request, response);
    }

    public static void applyPolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String policyId = HttpUtils.getStringParameter(request, "policyId");
        service.applyPolicy(repositoryId, policyId, objectId, null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, objectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        response.setStatus(200);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert(object, typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void removePolicy(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String policyId = HttpUtils.getStringParameter(request, "policyId");
        service.removePolicy(repositoryId, policyId, objectId, null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, objectId);
        if (object == null) {
            throw new CmisRuntimeException("Object is null!");
        }
        response.setStatus(200);
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert(object, typeCache);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }
}

