/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class RelationshipService {
    public static void getObjectRelationships(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        Boolean includeAllowableActions;
        String renditionFilter;
        String typeId;
        RelationshipDirection relationshipDirection;
        Boolean includeSubRelationshipTypes;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        ObjectList relationships = service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes = HttpUtils.getBooleanParameter(request, "includeSubRelationshipTypes"), relationshipDirection = HttpUtils.getEnumParameter(request, "relationshipDirection", RelationshipDirection.class), typeId = HttpUtils.getStringParameter(request, "typeId"), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (relationships == null) {
            throw new CmisRuntimeException("Relationships are null!");
        }
        TypeCache typeCache = new TypeCache(repositoryId, service);
        JSONObject jsonChildren = JSONConverter.convert(relationships, typeCache);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonChildren, request, response);
    }
}

