/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.json.JSONConverter;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

public final class RepositoryService {
    private RepositoryService() {
    }

    public static void getRepositories(CallContext context, CmisService service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List infoDataList = service.getRepositoryInfos(null);
        JSONObject result = new JSONObject();
        for (RepositoryInfo ri : infoDataList) {
            result.put((Object)ri.getId(), (Object)JSONConverter.convert(ri, request));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)result, request, response);
    }

    public static void getRepositoryInfo(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RepositoryInfo ri = service.getRepositoryInfo(repositoryId, null);
        JSONObject jsonRi = JSONConverter.convert(ri, request);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonRi, request, response);
    }

    public static void getLastResult(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String transaction = HttpUtils.getStringParameter(request, "transaction");
        String cookieName = BrowserBindingUtils.getCookieName(transaction);
        String cookieValue = null;
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                cookieValue = cookie.getValue();
                break;
            }
        }
        try {
            if (cookieValue == null) {
                cookieValue = BrowserBindingUtils.createCookieValue(0, null, "invalidArgument", "Unknown transaction!");
            } else {
                JSONValue.parse(cookieValue);
            }
        }
        catch (Exception pe) {
            cookieValue = BrowserBindingUtils.createCookieValue(0, null, "runtime", "Cookie pasring error!");
        }
        BrowserBindingUtils.deleteCookie(request, response, repositoryId, transaction);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)((JSONObject)JSONValue.parse((String)cookieValue)), request, response);
    }

    public static void getTypeChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        boolean includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false);
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        TypeDefinitionList typeList = service.getTypeChildren(repositoryId, typeId, Boolean.valueOf(includePropertyDefinitions), maxItems, skipCount, null);
        JSONObject jsonTypeList = JSONConverter.convert(typeList);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonTypeList, request, response);
    }

    public static void getTypeDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean includePropertyDefinitions;
        BigInteger depth;
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        List typeTree = service.getTypeDescendants(repositoryId, typeId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), Boolean.valueOf(includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false)), null);
        if (typeTree == null) {
            throw new CmisRuntimeException("Type tree is null!");
        }
        JSONArray jsonTypeTree = new JSONArray();
        for (TypeDefinitionContainer container : typeTree) {
            jsonTypeTree.add((Object)JSONConverter.convert(container));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonTypeTree, request, response);
    }

    public static void getTypeDefinition(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        TypeDefinition type = service.getTypeDefinition(repositoryId, typeId, null);
        JSONObject jsonType = JSONConverter.convert(type);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonType, request, response);
    }
}

