/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser.json;

import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.TypeCache;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONConverter {
    private JSONConverter() {
    }

    public static JSONObject convert(RepositoryInfo repositoryInfo, HttpServletRequest request) {
        if (repositoryInfo == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"repositoryId", (Object)repositoryInfo.getId());
        result.put((Object)"repositoryName", (Object)repositoryInfo.getName());
        result.put((Object)"repositoryDescription", (Object)repositoryInfo.getDescription());
        result.put((Object)"vendorName", (Object)repositoryInfo.getVendorName());
        result.put((Object)"productName", (Object)repositoryInfo.getProductName());
        result.put((Object)"productVersion", (Object)repositoryInfo.getProductVersion());
        result.put((Object)"rootFolderId", (Object)repositoryInfo.getRootFolderId());
        result.put((Object)"capabilities", (Object)JSONConverter.convert(repositoryInfo.getCapabilities()));
        result.put((Object)"aclCapabilities", (Object)JSONConverter.convert(repositoryInfo.getAclCapabilities()));
        result.put((Object)"latestChangeLogToken", (Object)repositoryInfo.getLatestChangeLogToken());
        result.put((Object)"cmisVersionSupported", (Object)repositoryInfo.getCmisVersionSupported());
        result.put((Object)"thinClientURI", (Object)repositoryInfo.getThinClientUri());
        result.put((Object)"changesIncomplete", (Object)repositoryInfo.getChangesIncomplete());
        if (repositoryInfo.getChangesOnType() != null) {
            JSONArray changesOnType = new JSONArray();
            for (BaseTypeId type : repositoryInfo.getChangesOnType()) {
                changesOnType.add((Object)JSONConverter.getJSONStringValue(type));
            }
            result.put((Object)"changesOnType", (Object)changesOnType);
        }
        result.put((Object)"principalIdAnonymous", (Object)repositoryInfo.getPrincipalIdAnonymous());
        result.put((Object)"principalIdAnyone", (Object)repositoryInfo.getPrincipalIdAnyone());
        result.put((Object)"repositoryUrl", (Object)BrowserBindingUtils.compileRepositoryUrl(request, repositoryInfo.getId()).toString());
        result.put((Object)"rootFolderUrl", (Object)BrowserBindingUtils.compileRootUrl(request, repositoryInfo.getId()).toString());
        return result;
    }

    public static JSONObject convert(RepositoryCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"capabilityContentStreamUpdatability", (Object)JSONConverter.getJSONStringValue(capabilities.getContentStreamUpdatesCapability().value()));
        result.put((Object)"capabilityChanges", (Object)JSONConverter.getJSONStringValue(capabilities.getChangesCapability().value()));
        result.put((Object)"capabilityRenditions", (Object)JSONConverter.getJSONStringValue(capabilities.getRenditionsCapability().value()));
        result.put((Object)"capabilityGetDescendants", (Object)capabilities.isGetDescendantsSupported());
        result.put((Object)"capabilityGetFolderTree", (Object)capabilities.isGetFolderTreeSupported());
        result.put((Object)"capabilityMultifiling", (Object)capabilities.isMultifilingSupported());
        result.put((Object)"capabilityUnfiling", (Object)capabilities.isUnfilingSupported());
        result.put((Object)"capabilityVersionSpecificFiling", (Object)capabilities.isVersionSpecificFilingSupported());
        result.put((Object)"capabilityPWCSearchable", (Object)capabilities.isPwcSearchableSupported());
        result.put((Object)"capabilityPWCUpdatable", (Object)capabilities.isPwcUpdatableSupported());
        result.put((Object)"capabilityAllVersionsSearchable", (Object)capabilities.isAllVersionsSearchableSupported());
        result.put((Object)"capabilityQuery", (Object)JSONConverter.getJSONStringValue(capabilities.getQueryCapability().value()));
        result.put((Object)"capabilityJoin", (Object)JSONConverter.getJSONStringValue(capabilities.getJoinCapability().value()));
        result.put((Object)"capabilityACL", (Object)JSONConverter.getJSONStringValue(capabilities.getAclCapability().value()));
        return result;
    }

    public static JSONObject convert(AclCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"supportedPermissions", (Object)JSONConverter.getJSONStringValue(capabilities.getSupportedPermissions().value()));
        result.put((Object)"propagation", (Object)JSONConverter.getJSONStringValue(capabilities.getAclPropagation().value()));
        if (capabilities.getPermissions() != null) {
            JSONArray permissions = new JSONArray();
            for (PermissionDefinition permDef : capabilities.getPermissions()) {
                JSONObject permission = new JSONObject();
                permission.put((Object)"permission", (Object)permDef.getId());
                permission.put((Object)"description", (Object)permDef.getDescription());
                permissions.add((Object)permission);
            }
            result.put((Object)"permissions", (Object)permissions);
        }
        if (capabilities.getPermissionMapping() != null) {
            JSONArray permissionMapping = new JSONArray();
            for (PermissionMapping permMap : capabilities.getPermissionMapping().values()) {
                JSONArray mappingPermissions = new JSONArray();
                if (permMap.getPermissions() != null) {
                    for (String p : permMap.getPermissions()) {
                        mappingPermissions.add((Object)p);
                    }
                }
                JSONObject mapping = new JSONObject();
                mapping.put((Object)"key", (Object)permMap.getKey());
                mapping.put((Object)"permission", (Object)mappingPermissions);
                permissionMapping.add((Object)mapping);
            }
            result.put((Object)"permissionMapping", (Object)permissionMapping);
        }
        return result;
    }

    public static JSONObject convert(ObjectData object, TypeCache typeCache) {
        JSONObject properties;
        if (object == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (object.getProperties() != null && (properties = JSONConverter.convert(object.getProperties(), object.getId(), typeCache)) != null) {
            result.put((Object)"properties", (Object)properties);
        }
        if (object.getAllowableActions() != null) {
            result.put((Object)"allowableActions", (Object)JSONConverter.convert(object.getAllowableActions()));
        }
        if (object.getRelationships() != null) {
            JSONArray relationships = new JSONArray();
            for (ObjectData relationship : object.getRelationships()) {
                relationships.add((Object)JSONConverter.convert(relationship, typeCache));
            }
            result.put((Object)"relationships", (Object)relationships);
        }
        if (object.getChangeEventInfo() != null) {
            JSONObject changeEventInfo = new JSONObject();
            ChangeEventInfo cei = object.getChangeEventInfo();
            changeEventInfo.put((Object)"changeType", (Object)JSONConverter.getJSONStringValue(cei.getChangeType().value()));
            changeEventInfo.put((Object)"changeTime", JSONConverter.getJSONValue(cei.getChangeTime()));
            result.put((Object)"changeEventInfo", (Object)changeEventInfo);
        }
        if (object.getAcl() != null && object.getAcl().getAces() != null) {
            result.put((Object)"acl", (Object)JSONConverter.convert(object.getAcl()));
            result.put((Object)"exactACL", (Object)object.isExactAcl());
        }
        if (object.getPolicyIds() != null && object.getPolicyIds().getPolicyIds() != null) {
            JSONArray policyIds = new JSONArray();
            for (String pi : object.getPolicyIds().getPolicyIds()) {
                policyIds.add((Object)pi);
            }
            result.put((Object)"policyIds", (Object)policyIds);
        }
        if (object.getRenditions() != null) {
            JSONArray renditions = new JSONArray();
            for (RenditionData rendition : object.getRenditions()) {
                renditions.add((Object)JSONConverter.convert(rendition));
            }
            result.put((Object)"renditions", (Object)renditions);
        }
        return result;
    }

    public static JSONObject convert(Properties properties, String objectId, TypeCache typeCache) {
        if (properties == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        for (PropertyData property : properties.getPropertyList()) {
            TypeDefinition type = null;
            if (typeCache != null) {
                type = typeCache.getTypeDefinitionForObject(objectId);
            }
            PropertyDefinition propDef = null;
            if (type != null) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(property.getId());
            }
            result.put((Object)property.getId(), (Object)JSONConverter.convert(property, propDef));
        }
        return result;
    }

    public static JSONObject convert(PropertyData<?> property, PropertyDefinition<?> propDef) {
        if (property == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)property.getId());
        result.put((Object)"localName", (Object)property.getLocalName());
        result.put((Object)"displayName", (Object)property.getDisplayName());
        result.put((Object)"queryName", (Object)property.getQueryName());
        if (propDef != null) {
            result.put((Object)"type", (Object)propDef.getPropertyType().value());
            result.put((Object)"cardinality", (Object)propDef.getCardinality().value());
            if (property.getValues() == null || property.getValues().size() == 0) {
                result.put((Object)"value", null);
            } else if (propDef.getCardinality() == Cardinality.SINGLE) {
                result.put((Object)"value", JSONConverter.getJSONValue(property.getValues().get(0)));
            } else {
                JSONArray values = new JSONArray();
                for (Object value : property.getValues()) {
                    values.add(JSONConverter.getJSONValue(value));
                }
                result.put((Object)"value", (Object)values);
            }
        } else {
            result.put((Object)"type", (Object)JSONConverter.getJSONPropertyDataType(property));
            if (property.getValues() == null || property.getValues().size() == 0) {
                result.put((Object)"value", null);
            } else if (property.getValues().size() > 0) {
                JSONArray values = new JSONArray();
                for (Object value : property.getValues()) {
                    values.add(JSONConverter.getJSONValue(value));
                }
                result.put((Object)"value", (Object)values);
            }
        }
        return result;
    }

    public static JSONObject convert(AllowableActions allowableActions) {
        if (allowableActions == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        Set actionSet = allowableActions.getAllowableActions();
        for (Action action : Action.values()) {
            result.put((Object)action.value(), (Object)actionSet.contains(action));
        }
        return result;
    }

    public static JSONObject convert(Acl acl) {
        if (acl == null || acl.getAces() == null) {
            return null;
        }
        JSONArray aceObjects = new JSONArray();
        for (Ace ace : acl.getAces()) {
            JSONArray permissions = new JSONArray();
            if (ace.getPermissions() != null) {
                for (String p : ace.getPermissions()) {
                    permissions.add((Object)p);
                }
            }
            JSONObject aceObject = new JSONObject();
            JSONObject principalObjecy = new JSONObject();
            principalObjecy.put((Object)"princialId", (Object)ace.getPrincipalId());
            aceObject.put((Object)"princial", (Object)principalObjecy);
            aceObject.put((Object)"permissions", (Object)permissions);
            aceObject.put((Object)"isDirect", (Object)ace.isDirect());
            aceObjects.add((Object)aceObject);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"aces", (Object)aceObjects);
        result.put((Object)"isExact", (Object)acl.isExact());
        return result;
    }

    public static JSONObject convert(RenditionData rendition) {
        if (rendition == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"streamId", (Object)rendition.getStreamId());
        result.put((Object)"mimeType", (Object)rendition.getMimeType());
        result.put((Object)"length", (Object)rendition.getBigLength());
        result.put((Object)"kind", (Object)rendition.getKind());
        result.put((Object)"title", (Object)rendition.getTitle());
        result.put((Object)"height", (Object)rendition.getBigHeight());
        result.put((Object)"width", (Object)rendition.getBigWidth());
        result.put((Object)"renditionDocumentId", (Object)rendition.getRenditionDocumentId());
        return result;
    }

    public static JSONObject convert(ObjectList list, TypeCache typeCache) {
        if (list == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray objects = new JSONArray();
        if (list.getObjects() != null) {
            for (ObjectData object : list.getObjects()) {
                objects.add((Object)JSONConverter.convert(object, typeCache));
            }
        }
        result.put((Object)"objects", (Object)objects);
        if (list.hasMoreItems() != null) {
            result.put((Object)"hasMoreItems", (Object)list.hasMoreItems());
        }
        if (list.getNumItems() != null) {
            result.put((Object)"numItems", (Object)list.getNumItems());
        }
        return result;
    }

    public static JSONObject convert(ObjectInFolderData objectInFolder, TypeCache typeCache) {
        if (objectInFolder == null || objectInFolder.getObject() == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"object", (Object)JSONConverter.convert(objectInFolder.getObject(), typeCache));
        if (objectInFolder.getPathSegment() != null) {
            result.put((Object)"pathSegment", (Object)objectInFolder.getPathSegment());
        }
        return result;
    }

    public static JSONObject convert(ObjectInFolderList objectInFolderList, TypeCache typeCache) {
        if (objectInFolderList == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (objectInFolderList.getObjects() != null) {
            JSONArray objects = new JSONArray();
            for (ObjectInFolderData object : objectInFolderList.getObjects()) {
                objects.add((Object)JSONConverter.convert(object, typeCache));
            }
            result.put((Object)"objects", (Object)objects);
        }
        if (objectInFolderList.hasMoreItems() != null) {
            result.put((Object)"hasMoreItems", (Object)objectInFolderList.hasMoreItems());
        }
        if (objectInFolderList.getNumItems() != null) {
            result.put((Object)"numItems", (Object)objectInFolderList.getNumItems());
        }
        return result;
    }

    public static JSONObject convert(ObjectInFolderContainer container, TypeCache typeCache) {
        if (container == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"object", (Object)JSONConverter.convert(container.getObject(), typeCache));
        if (container.getChildren() != null && container.getChildren().size() > 0) {
            JSONArray children = new JSONArray();
            for (ObjectInFolderContainer descendant : container.getChildren()) {
                children.add((Object)JSONConverter.convert(descendant, typeCache));
            }
            result.put((Object)"children", (Object)children);
        }
        return result;
    }

    public static JSONObject convert(ObjectParentData parent, TypeCache typeCache) {
        if (parent == null || parent.getObject() == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"object", (Object)JSONConverter.convert(parent.getObject(), typeCache));
        if (parent.getRelativePathSegment() != null) {
            result.put((Object)"relativePathSegment", (Object)parent.getRelativePathSegment());
        }
        return result;
    }

    public static JSONObject convert(TypeDefinition type) {
        if (type == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)type.getId());
        result.put((Object)"localName", (Object)type.getLocalName());
        result.put((Object)"localNamespace", (Object)type.getLocalNamespace());
        result.put((Object)"displayName", (Object)type.getDisplayName());
        result.put((Object)"queryName", (Object)type.getQueryName());
        result.put((Object)"description", (Object)type.getDescription());
        result.put((Object)"baseId", (Object)type.getBaseTypeId().value());
        result.put((Object)"parentId", (Object)type.getParentTypeId());
        result.put((Object)"creatable", (Object)type.isCreatable());
        result.put((Object)"fileable", (Object)type.isFileable());
        result.put((Object)"queryable", (Object)type.isQueryable());
        result.put((Object)"fulltextIndexed", (Object)type.isFulltextIndexed());
        result.put((Object)"includedInSupertypeQuery", (Object)type.isIncludedInSupertypeQuery());
        result.put((Object)"controllablePolicy", (Object)type.isControllablePolicy());
        result.put((Object)"controllableACL", (Object)type.isControllableAcl());
        if (type instanceof DocumentTypeDefinition) {
            result.put((Object)"versionable", (Object)((DocumentTypeDefinition)type).isVersionable());
            result.put((Object)"contentStreamAllowed", (Object)((DocumentTypeDefinition)type).getContentStreamAllowed().value());
        }
        if (type instanceof RelationshipTypeDefinition) {
            result.put((Object)"allowedSourceTypes", (Object)JSONConverter.getJSONArrayFromList(((RelationshipTypeDefinition)type).getAllowedSourceTypeIds()));
            result.put((Object)"allowedTargetTypes", (Object)JSONConverter.getJSONArrayFromList(((RelationshipTypeDefinition)type).getAllowedTargetTypeIds()));
        }
        if (type.getPropertyDefinitions() != null && !type.getPropertyDefinitions().isEmpty()) {
            JSONObject propertyDefs = new JSONObject();
            for (PropertyDefinition pd : type.getPropertyDefinitions().values()) {
                propertyDefs.put((Object)pd.getId(), (Object)JSONConverter.convert(pd));
            }
            result.put((Object)"propertyDefinitions", (Object)propertyDefs);
        }
        return result;
    }

    public static JSONObject convert(PropertyDefinition<?> propertyDef) {
        if (propertyDef == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)propertyDef.getId());
        result.put((Object)"localName", (Object)propertyDef.getLocalName());
        result.put((Object)"localNamespace", (Object)propertyDef.getLocalName());
        result.put((Object)"displayName", (Object)propertyDef.getDisplayName());
        result.put((Object)"queryName", (Object)propertyDef.getQueryName());
        result.put((Object)"description", (Object)propertyDef.getDescription());
        result.put((Object)"propertyType", (Object)propertyDef.getPropertyType().value());
        result.put((Object)"cardinality", (Object)propertyDef.getCardinality().value());
        result.put((Object)"updatability", (Object)propertyDef.getUpdatability().value());
        result.put((Object)"inherited", (Object)propertyDef.isInherited());
        result.put((Object)"required", (Object)propertyDef.isRequired());
        result.put((Object)"queryable", (Object)propertyDef.isQueryable());
        result.put((Object)"openChoice", (Object)propertyDef.isOpenChoice());
        return result;
    }

    public static JSONObject convert(TypeDefinitionList list) {
        if (list == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        if (list.getList() != null) {
            JSONArray objects = new JSONArray();
            for (TypeDefinition type : list.getList()) {
                objects.add((Object)JSONConverter.convert(type));
            }
            result.put((Object)"types", (Object)objects);
        }
        result.put((Object)"hasMoreItems", (Object)list.hasMoreItems());
        result.put((Object)"numItems", (Object)list.getNumItems());
        return result;
    }

    public static JSONObject convert(TypeDefinitionContainer container) {
        if (container == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)"type", (Object)JSONConverter.convert(container.getTypeDefinition()));
        if (container.getChildren() != null && container.getChildren().size() > 0) {
            JSONArray children = new JSONArray();
            for (TypeDefinitionContainer child : container.getChildren()) {
                children.add((Object)JSONConverter.convert(child));
            }
            result.put((Object)"children", (Object)children);
        }
        return result;
    }

    public static String getJSONStringValue(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static Object getJSONValue(Object value) {
        if (value instanceof GregorianCalendar) {
            return ((GregorianCalendar)value).getTimeInMillis();
        }
        return value;
    }

    public static JSONArray getJSONArrayFromList(List<?> list) {
        if (list == null) {
            return null;
        }
        JSONArray result = new JSONArray();
        result.addAll(list);
        return result;
    }

    public static String getJSONPropertyDataType(PropertyData<?> property) {
        if (property instanceof PropertyBoolean) {
            return PropertyType.BOOLEAN.value();
        }
        if (property instanceof PropertyId) {
            return PropertyType.ID.value();
        }
        if (property instanceof PropertyInteger) {
            return PropertyType.INTEGER.value();
        }
        if (property instanceof PropertyDateTime) {
            return PropertyType.DATETIME.value();
        }
        if (property instanceof PropertyDecimal) {
            return PropertyType.DECIMAL.value();
        }
        if (property instanceof PropertyHtml) {
            return PropertyType.HTML.value();
        }
        if (property instanceof PropertyString) {
            return PropertyType.STRING.value();
        }
        if (property instanceof PropertyUri) {
            return PropertyType.URI.value();
        }
        return null;
    }
}

